/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.security.provider;

import de.adorsys.psd2.consent.service.security.DecryptedData;
import de.adorsys.psd2.consent.service.security.EncryptedData;
import de.adorsys.psd2.consent.service.security.provider.CryptoProviderAlgorithmVersion;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Optional;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public interface CryptoProvider {
    public static final String SKF_ALGORITHM = "PBKDF2WithHmacSHA256";

    public Optional<EncryptedData> encryptData(byte[] var1, String var2);

    public Optional<DecryptedData> decryptData(byte[] var1, String var2);

    public CryptoProviderAlgorithmVersion getAlgorithmVersion();

    default public SecretKey getSecretKey(String password) throws InvalidKeySpecException, NoSuchAlgorithmException {
        byte[] salt = new byte[16];
        SecretKeyFactory factory = SecretKeyFactory.getInstance(SKF_ALGORITHM);
        PBEKeySpec keySpec = new PBEKeySpec(password.toCharArray(), salt, 65536, 256);
        SecretKey secretKey = factory.generateSecret(keySpec);
        return new SecretKeySpec(secretKey.getEncoded(), "AES");
    }
}

