/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.mapper;

import de.adorsys.psd2.consent.domain.piis.PiisConsentEntity;
import de.adorsys.psd2.consent.service.mapper.AccountReferenceMapper;
import de.adorsys.psd2.consent.service.mapper.PsuDataMapper;
import de.adorsys.psd2.consent.service.mapper.TppInfoMapper;
import de.adorsys.psd2.xs2a.core.piis.PiisConsent;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class PiisConsentMapper {
    private final PsuDataMapper psuDataMapper;
    private final TppInfoMapper tppInfoMapper;
    private final AccountReferenceMapper accountReferenceMapper;

    public PiisConsent mapToPiisConsent(PiisConsentEntity piisConsentEntity) {
        return new PiisConsent(piisConsentEntity.getExternalId(), piisConsentEntity.isRecurringIndicator(), piisConsentEntity.getRequestDateTime(), piisConsentEntity.getLastActionDate(), piisConsentEntity.getExpireDate(), this.psuDataMapper.mapToPsuIdData(piisConsentEntity.getPsuData()), this.tppInfoMapper.mapToTppInfo(piisConsentEntity.getTppInfo()), piisConsentEntity.getConsentStatus(), this.accountReferenceMapper.mapToAccountReferenceList(piisConsentEntity.getAccounts()), piisConsentEntity.getTppAccessType(), piisConsentEntity.getAllowedFrequencyPerDay(), piisConsentEntity.getCreationTimestamp(), piisConsentEntity.getInstanceId());
    }

    public List<PiisConsent> mapToPiisConsentList(List<PiisConsentEntity> consentEntities) {
        return consentEntities.stream().map(this::mapToPiisConsent).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"psuDataMapper", "tppInfoMapper", "accountReferenceMapper"})
    public PiisConsentMapper(PsuDataMapper psuDataMapper, TppInfoMapper tppInfoMapper, AccountReferenceMapper accountReferenceMapper) {
        this.psuDataMapper = psuDataMapper;
        this.tppInfoMapper = tppInfoMapper;
        this.accountReferenceMapper = accountReferenceMapper;
    }
}

