/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class JsonConverterService {
    private static final Logger log = LoggerFactory.getLogger(JsonConverterService.class);
    private final ObjectMapper objectMapper;

    public <T> Optional<byte[]> toJsonBytes(T object) {
        try {
            return Optional.ofNullable(this.objectMapper.writeValueAsBytes(object));
        }
        catch (JsonProcessingException e) {
            log.info("Can't convert object to json: {}", (Object)e.getMessage(), (Object)e);
            return Optional.empty();
        }
    }

    public <T> Optional<T> toObject(byte[] bytes, Class<T> target) {
        try {
            return Optional.ofNullable(this.objectMapper.readValue(bytes, target));
        }
        catch (IOException e) {
            log.info("Can't convert json to object: {}", (Object)e.getMessage(), (Object)e);
            return Optional.empty();
        }
    }

    @ConstructorProperties(value={"objectMapper"})
    public JsonConverterService(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

