/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.domain.account.AisConsent;
import de.adorsys.psd2.consent.domain.account.AisConsentUsage;
import de.adorsys.psd2.consent.repository.AisConsentUsageRepository;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AisConsentUsageService {
    private final AisConsentUsageRepository aisConsentUsageRepository;

    @Transactional
    public void incrementUsage(AisConsent aisConsent) {
        AisConsentUsage aisConsentUsage = this.getUsage(aisConsent);
        int usage = aisConsentUsage.getUsage();
        aisConsentUsage.setUsage(++usage);
        this.aisConsentUsageRepository.save(aisConsentUsage);
    }

    @Transactional
    public void resetUsage(AisConsent aisConsent) {
        AisConsentUsage aisConsentUsage = this.getUsage(aisConsent);
        aisConsentUsage.setUsage(0);
        this.aisConsentUsageRepository.save(aisConsentUsage);
    }

    @Transactional
    public int getUsageCounter(AisConsent aisConsent) {
        Integer usage = this.aisConsentUsageRepository.findReadByConsentAndUsageDate(aisConsent, LocalDate.now()).map(AisConsentUsage::getUsage).orElse(0);
        return Math.max(aisConsent.getAllowedFrequencyPerDay() - usage, 0);
    }

    private AisConsentUsage getUsage(AisConsent aisConsent) {
        return this.aisConsentUsageRepository.findWriteByConsentAndUsageDate(aisConsent, LocalDate.now()).orElseGet(() -> {
            AisConsentUsage usage = new AisConsentUsage(aisConsent);
            aisConsent.addUsage(usage);
            return usage;
        });
    }

    @ConstructorProperties(value={"aisConsentUsageRepository"})
    public AisConsentUsageService(AisConsentUsageRepository aisConsentUsageRepository) {
        this.aisConsentUsageRepository = aisConsentUsageRepository;
    }
}

