/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.repository.specification;

import de.adorsys.psd2.consent.domain.piis.PiisConsentEntity;
import de.adorsys.psd2.consent.repository.specification.EntityAttributeSpecificationProvider;
import de.adorsys.psd2.consent.repository.specification.GenericSpecification;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import java.time.LocalDate;
import javax.persistence.criteria.Join;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.domain.Specifications;
import org.springframework.stereotype.Service;

@Service
public class PiisConsentEntitySpecification
extends GenericSpecification {
    public Specification<PiisConsentEntity> byConsentIdAndInstanceId(String consentId, String instanceId) {
        return Specifications.where(EntityAttributeSpecificationProvider.provideSpecificationForEntityAttribute("instanceId", instanceId)).and(EntityAttributeSpecificationProvider.provideSpecificationForEntityAttribute("externalId", consentId));
    }

    public Specification<PiisConsentEntity> byTppIdAndCreationPeriodAndPsuIdDataAndInstanceId(@NotNull String tppAuthorisationNumber, @Nullable LocalDate createDateFrom, @Nullable LocalDate createDateTo, @Nullable PsuIdData psuIdData, @Nullable String instanceId) {
        return Specifications.where(this.byTppAuthorisationNumber(tppAuthorisationNumber)).and(this.byCreationTimestamp(createDateFrom, createDateTo)).and(this.byPsuIdData(psuIdData)).and(this.byInstanceId(instanceId));
    }

    public Specification<PiisConsentEntity> byPsuIdDataAndCreationPeriodAndInstanceId(@NotNull PsuIdData psuIdData, @Nullable LocalDate createDateFrom, @Nullable LocalDate createDateTo, @Nullable String instanceId) {
        return Specifications.where(this.byPsuIdData(psuIdData)).and(this.byCreationTimestamp(createDateFrom, createDateTo)).and(this.byInstanceId(instanceId));
    }

    public Specification<PiisConsentEntity> byAspspAccountIdAndCreationPeriodAndInstanceId(@NotNull String aspspAccountId, @Nullable LocalDate createDateFrom, @Nullable LocalDate createDateTo, @Nullable String instanceId) {
        return Specifications.where(this.byAspspAccountIdInAccounts(aspspAccountId)).and(this.byCreationTimestamp(createDateFrom, createDateTo)).and(this.byInstanceId(instanceId));
    }

    private Specification<PiisConsentEntity> byAspspAccountIdInAccounts(@Nullable String aspspAccountId) {
        return (root, query, cb) -> {
            Join accountsJoin = root.join("accounts");
            return EntityAttributeSpecificationProvider.provideSpecificationForJoinedEntityAttribute(accountsJoin, "aspspAccountId", aspspAccountId).toPredicate(root, query, cb);
        };
    }
}

