/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.aspsp.api.piis.CmsAspspPiisService;
import de.adorsys.psd2.consent.domain.piis.PiisConsentEntity;
import de.adorsys.psd2.consent.repository.PiisConsentRepository;
import de.adorsys.psd2.consent.repository.specification.PiisConsentEntitySpecification;
import de.adorsys.psd2.consent.service.mapper.AccountReferenceMapper;
import de.adorsys.psd2.consent.service.mapper.PiisConsentMapper;
import de.adorsys.psd2.consent.service.mapper.PsuDataMapper;
import de.adorsys.psd2.consent.service.mapper.TppInfoMapper;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.piis.PiisConsent;
import de.adorsys.psd2.xs2a.core.piis.PiisConsentTppAccessType;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CmsAspspPiisServiceInternal
implements CmsAspspPiisService {
    private final PiisConsentRepository piisConsentRepository;
    private final PiisConsentEntitySpecification piisConsentEntitySpecification;
    private final PiisConsentMapper piisConsentMapper;
    private final PsuDataMapper psuDataMapper;
    private final TppInfoMapper tppInfoMapper;
    private final AccountReferenceMapper accountReferenceMapper;

    @Transactional
    public Optional<String> createConsent(@NotNull PsuIdData psuIdData, @Nullable TppInfo tppInfo, @NotNull List<AccountReference> accounts, @NotNull LocalDate validUntil, int allowedFrequencyPerDay) {
        if (this.isInvalidConsentCreationRequest(psuIdData, tppInfo, accounts, validUntil)) {
            return Optional.empty();
        }
        PiisConsentEntity consent = this.buildPiisConsent(psuIdData, tppInfo, accounts, validUntil, allowedFrequencyPerDay);
        consent.setExternalId(UUID.randomUUID().toString());
        PiisConsentEntity saved = (PiisConsentEntity)this.piisConsentRepository.save(consent);
        return saved.getId() != null ? Optional.ofNullable(saved.getExternalId()) : Optional.empty();
    }

    @NotNull
    public List<PiisConsent> getConsentsForPsu(@NotNull PsuIdData psuIdData, @NotNull String instanceId) {
        return this.piisConsentRepository.findAll(this.piisConsentEntitySpecification.byPsuIdAndInstanceId(psuIdData.getPsuId(), instanceId)).stream().map(this.piisConsentMapper::mapToPiisConsent).collect(Collectors.toList());
    }

    @Transactional
    public boolean terminateConsent(@NotNull String consentId, @NotNull String instanceId) {
        Optional<Object> entityOptional = Optional.ofNullable(this.piisConsentRepository.findOne(this.piisConsentEntitySpecification.byConsentIdAndInstanceId(consentId, instanceId)));
        if (!entityOptional.isPresent()) {
            return false;
        }
        PiisConsentEntity entity = (PiisConsentEntity)entityOptional.get();
        entity.setLastActionDate(LocalDate.now());
        entity.setConsentStatus(ConsentStatus.TERMINATED_BY_ASPSP);
        this.piisConsentRepository.save(entity);
        return true;
    }

    private PiisConsentEntity buildPiisConsent(PsuIdData psuIdData, TppInfo tppInfo, List<AccountReference> accounts, LocalDate validUntil, int allowedFrequencyPerDay) {
        PiisConsentEntity consent = new PiisConsentEntity();
        consent.setConsentStatus(ConsentStatus.VALID);
        consent.setRequestDateTime(OffsetDateTime.now());
        consent.setExpireDate(validUntil);
        consent.setPsuData(this.psuDataMapper.mapToPsuData(psuIdData));
        consent.setTppInfo(this.tppInfoMapper.mapToTppInfoEntity(tppInfo));
        consent.setAccounts(this.accountReferenceMapper.mapToAccountReferenceEntityList(accounts));
        PiisConsentTppAccessType accessType = tppInfo != null ? PiisConsentTppAccessType.SINGLE_TPP : PiisConsentTppAccessType.ALL_TPP;
        consent.setTppAccessType(accessType);
        consent.setAllowedFrequencyPerDay(allowedFrequencyPerDay);
        return consent;
    }

    private boolean isInvalidConsentCreationRequest(@NotNull PsuIdData psuIdData, @Nullable TppInfo tppInfo, @NotNull List<AccountReference> accounts, @NotNull LocalDate validUntil) {
        boolean invalidTpp = tppInfo != null && tppInfo.isNotValid();
        return invalidTpp || psuIdData.isEmpty() || CollectionUtils.isEmpty(accounts) || validUntil.isBefore(LocalDate.now());
    }

    @ConstructorProperties(value={"piisConsentRepository", "piisConsentEntitySpecification", "piisConsentMapper", "psuDataMapper", "tppInfoMapper", "accountReferenceMapper"})
    public CmsAspspPiisServiceInternal(PiisConsentRepository piisConsentRepository, PiisConsentEntitySpecification piisConsentEntitySpecification, PiisConsentMapper piisConsentMapper, PsuDataMapper psuDataMapper, TppInfoMapper tppInfoMapper, AccountReferenceMapper accountReferenceMapper) {
        this.piisConsentRepository = piisConsentRepository;
        this.piisConsentEntitySpecification = piisConsentEntitySpecification;
        this.piisConsentMapper = piisConsentMapper;
        this.psuDataMapper = psuDataMapper;
        this.tppInfoMapper = tppInfoMapper;
        this.accountReferenceMapper = accountReferenceMapper;
    }
}

