/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.api.CmsScaMethod;
import de.adorsys.psd2.consent.api.ais.AisAccountAccessInfo;
import de.adorsys.psd2.consent.api.ais.AisAccountConsent;
import de.adorsys.psd2.consent.api.ais.AisConsentActionRequest;
import de.adorsys.psd2.consent.api.ais.AisConsentAuthorizationRequest;
import de.adorsys.psd2.consent.api.ais.AisConsentAuthorizationResponse;
import de.adorsys.psd2.consent.api.ais.CreateAisConsentRequest;
import de.adorsys.psd2.consent.api.service.AisConsentService;
import de.adorsys.psd2.consent.api.service.AisConsentServiceEncrypted;
import de.adorsys.psd2.consent.service.security.SecurityDataService;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class AisConsentServiceInternalEncrypted
implements AisConsentServiceEncrypted {
    private final SecurityDataService securityDataService;
    private final AisConsentService aisConsentService;

    @Transactional
    public Optional<String> createConsent(CreateAisConsentRequest request) {
        return this.aisConsentService.createConsent(request).flatMap(this.securityDataService::encryptId);
    }

    @Transactional
    public Optional<ConsentStatus> getConsentStatusById(String encryptedConsentId) {
        return this.securityDataService.decryptId(encryptedConsentId).flatMap(x$0 -> this.aisConsentService.getConsentStatusById(x$0));
    }

    @Transactional
    public boolean updateConsentStatusById(String encryptedConsentId, ConsentStatus status) {
        return this.securityDataService.decryptId(encryptedConsentId).map(id -> this.aisConsentService.updateConsentStatusById(id, status)).orElse(false);
    }

    @Transactional
    public Optional<AisAccountConsent> getAisAccountConsentById(String encryptedConsentId) {
        return this.securityDataService.decryptId(encryptedConsentId).flatMap(x$0 -> this.aisConsentService.getAisAccountConsentById(x$0));
    }

    public Optional<AisAccountConsent> getInitialAisAccountConsentById(String encryptedConsentId) {
        return this.securityDataService.decryptId(encryptedConsentId).flatMap(x$0 -> this.aisConsentService.getInitialAisAccountConsentById(x$0));
    }

    @Transactional
    public boolean findAndTerminateOldConsentsByNewConsentId(String encryptedNewConsentId) {
        return this.securityDataService.decryptId(encryptedNewConsentId).map(x$0 -> this.aisConsentService.findAndTerminateOldConsentsByNewConsentId(x$0)).orElse(false);
    }

    @Transactional
    public void checkConsentAndSaveActionLog(AisConsentActionRequest encryptedRequest) {
        String consentId = encryptedRequest.getConsentId();
        Optional<String> decryptedConsentId = this.securityDataService.decryptId(consentId);
        if (!decryptedConsentId.isPresent()) {
            return;
        }
        AisConsentActionRequest decryptedRequest = new AisConsentActionRequest(encryptedRequest.getTppId(), decryptedConsentId.get(), encryptedRequest.getActionStatus());
        this.aisConsentService.checkConsentAndSaveActionLog(decryptedRequest);
    }

    @Transactional
    public Optional<String> updateAspspAccountAccess(String encryptedConsentId, AisAccountAccessInfo request) {
        return this.securityDataService.decryptId(encryptedConsentId).flatMap(decrypted -> this.aisConsentService.updateAspspAccountAccess(decrypted, request)).flatMap(this.securityDataService::encryptId);
    }

    @Transactional
    public Optional<String> createAuthorization(String encryptedConsentId, AisConsentAuthorizationRequest request) {
        return this.securityDataService.decryptId(encryptedConsentId).flatMap(id -> this.aisConsentService.createAuthorization(id, request));
    }

    public Optional<AisConsentAuthorizationResponse> getAccountConsentAuthorizationById(String authorisationId, String encryptedConsentId) {
        return this.securityDataService.decryptId(encryptedConsentId).flatMap(id -> this.aisConsentService.getAccountConsentAuthorizationById(authorisationId, id));
    }

    @Transactional
    public boolean updateConsentAuthorization(String authorizationId, AisConsentAuthorizationRequest request) {
        return this.aisConsentService.updateConsentAuthorization(authorizationId, request);
    }

    public Optional<List<PsuIdData>> getPsuDataByConsentId(String encryptedConsentId) {
        return this.securityDataService.decryptId(encryptedConsentId).flatMap(x$0 -> this.aisConsentService.getPsuDataByConsentId(x$0));
    }

    public Optional<List<String>> getAuthorisationsByConsentId(String encryptedConsentId) {
        return this.securityDataService.decryptId(encryptedConsentId).flatMap(x$0 -> this.aisConsentService.getAuthorisationsByConsentId(x$0));
    }

    @Transactional
    public Optional<ScaStatus> getAuthorisationScaStatus(String encryptedConsentId, String authorisationId) {
        return this.securityDataService.decryptId(encryptedConsentId).flatMap(consentId -> this.aisConsentService.getAuthorisationScaStatus(consentId, authorisationId));
    }

    public boolean isAuthenticationMethodDecoupled(String authorisationId, String authenticationMethodId) {
        return this.aisConsentService.isAuthenticationMethodDecoupled(authorisationId, authenticationMethodId);
    }

    @Transactional
    public boolean saveAuthenticationMethods(String authorisationId, List<CmsScaMethod> methods) {
        return this.aisConsentService.saveAuthenticationMethods(authorisationId, methods);
    }

    @Transactional
    public boolean updateScaApproach(String authorisationId, ScaApproach scaApproach) {
        return this.aisConsentService.updateScaApproach(authorisationId, scaApproach);
    }

    @Transactional
    public boolean updateMultilevelScaRequired(String encryptedConsentId, boolean multilevelScaRequired) {
        return this.securityDataService.decryptId(encryptedConsentId).map(consentId -> this.aisConsentService.updateMultilevelScaRequired(consentId, multilevelScaRequired)).orElse(false);
    }

    @ConstructorProperties(value={"securityDataService", "aisConsentService"})
    public AisConsentServiceInternalEncrypted(SecurityDataService securityDataService, AisConsentService aisConsentService) {
        this.securityDataService = securityDataService;
        this.aisConsentService = aisConsentService;
    }
}

