/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.aspsp.profile.service.AspspProfileService;
import de.adorsys.psd2.consent.api.ActionStatus;
import de.adorsys.psd2.consent.api.CmsScaMethod;
import de.adorsys.psd2.consent.api.ais.AisAccountAccessInfo;
import de.adorsys.psd2.consent.api.ais.AisAccountConsent;
import de.adorsys.psd2.consent.api.ais.AisConsentActionRequest;
import de.adorsys.psd2.consent.api.ais.AisConsentAuthorizationRequest;
import de.adorsys.psd2.consent.api.ais.AisConsentAuthorizationResponse;
import de.adorsys.psd2.consent.api.ais.CreateAisConsentRequest;
import de.adorsys.psd2.consent.api.service.AisConsentService;
import de.adorsys.psd2.consent.domain.PsuData;
import de.adorsys.psd2.consent.domain.ScaMethod;
import de.adorsys.psd2.consent.domain.TppInfoEntity;
import de.adorsys.psd2.consent.domain.account.AisConsent;
import de.adorsys.psd2.consent.domain.account.AisConsentAction;
import de.adorsys.psd2.consent.domain.account.AisConsentAuthorization;
import de.adorsys.psd2.consent.domain.account.AspspAccountAccessHolder;
import de.adorsys.psd2.consent.domain.account.TppAccountAccessHolder;
import de.adorsys.psd2.consent.repository.AisConsentActionRepository;
import de.adorsys.psd2.consent.repository.AisConsentAuthorisationRepository;
import de.adorsys.psd2.consent.repository.AisConsentRepository;
import de.adorsys.psd2.consent.service.AisConsentConfirmationExpirationService;
import de.adorsys.psd2.consent.service.mapper.AisConsentMapper;
import de.adorsys.psd2.consent.service.mapper.PsuDataMapper;
import de.adorsys.psd2.consent.service.mapper.ScaMethodMapper;
import de.adorsys.psd2.consent.service.mapper.TppInfoMapper;
import de.adorsys.psd2.consent.service.psu.CmsPsuService;
import de.adorsys.psd2.xs2a.core.ais.AccountAccessType;
import de.adorsys.psd2.xs2a.core.consent.AisConsentRequestType;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class AisConsentServiceInternal
implements AisConsentService {
    private static final Logger log = LoggerFactory.getLogger(AisConsentServiceInternal.class);
    private final AisConsentRepository aisConsentRepository;
    private final AisConsentActionRepository aisConsentActionRepository;
    private final AisConsentAuthorisationRepository aisConsentAuthorisationRepository;
    private final AisConsentMapper consentMapper;
    private final PsuDataMapper psuDataMapper;
    private final AspspProfileService aspspProfileService;
    private final AisConsentConfirmationExpirationService aisConsentConfirmationExpirationService;
    private final TppInfoMapper tppInfoMapper;
    private final ScaMethodMapper scaMethodMapper;
    private final CmsPsuService cmsPsuService;

    @Transactional
    public Optional<String> createConsent(CreateAisConsentRequest request) {
        if (request.getAllowedFrequencyPerDay() == null) {
            log.info("TPP ID: [{}]. Consent cannot be created, because request contains no allowed frequency per day", (Object)request.getTppInfo().getAuthorisationNumber());
            return Optional.empty();
        }
        AisConsent consent = this.createConsentFromRequest(request);
        consent.setExternalId(UUID.randomUUID().toString());
        AisConsent saved = (AisConsent)this.aisConsentRepository.save(consent);
        return saved.getId() != null ? Optional.of(saved.getExternalId()) : Optional.empty();
    }

    @Transactional
    public Optional<ConsentStatus> getConsentStatusById(String consentId) {
        Optional<AisConsent> optionalConsentStatus = this.aisConsentRepository.findByExternalId(consentId);
        if (optionalConsentStatus.isPresent()) {
            return optionalConsentStatus.map(this.aisConsentConfirmationExpirationService::checkAndUpdateOnConfirmationExpiration).map(this::checkAndUpdateOnExpiration).map(AisConsent::getConsentStatus);
        }
        log.info("Consent ID: [{}]. Get consent failed, because consent is not found", (Object)consentId);
        return Optional.empty();
    }

    @Transactional
    public boolean updateConsentStatusById(String consentId, ConsentStatus status) {
        return this.getActualAisConsent(consentId).map(c -> this.setStatusAndSaveConsent((AisConsent)c, status)).orElse(false);
    }

    @Transactional
    public Optional<AisAccountConsent> getAisAccountConsentById(String consentId) {
        return this.aisConsentRepository.findByExternalId(consentId).map(this.aisConsentConfirmationExpirationService::checkAndUpdateOnConfirmationExpiration).map(this::checkAndUpdateOnExpiration).map(this.consentMapper::mapToAisAccountConsent);
    }

    public Optional<AisAccountConsent> getInitialAisAccountConsentById(String consentId) {
        return this.aisConsentRepository.findByExternalId(consentId).map(this::checkAndUpdateOnExpiration).map(this.consentMapper::mapToInitialAisAccountConsent);
    }

    @Transactional
    public boolean findAndTerminateOldConsentsByNewConsentId(String newConsentId) {
        TppInfoEntity tppInfo;
        AisConsent newConsent = this.aisConsentRepository.findByExternalId(newConsentId).orElseThrow(() -> new IllegalArgumentException("Wrong consent id: " + newConsentId));
        if (newConsent.isOneAccessType()) {
            return false;
        }
        if (newConsent.isWrongConsentData()) {
            throw new IllegalArgumentException("Wrong consent data");
        }
        List<PsuData> psuDataList = newConsent.getPsuDataList();
        Set<String> psuIds = psuDataList.stream().filter(Objects::nonNull).map(PsuData::getPsuId).collect(Collectors.toSet());
        List<AisConsent> oldConsents = this.aisConsentRepository.findOldConsentsByNewConsentParams(psuIds, (tppInfo = newConsent.getTppInfo()).getAuthorisationNumber(), tppInfo.getAuthorityId(), newConsent.getInstanceId(), newConsent.getExternalId(), EnumSet.of(ConsentStatus.RECEIVED, ConsentStatus.PARTIALLY_AUTHORISED, ConsentStatus.VALID));
        List<AisConsent> oldConsentsWithExactPsuDataLists = oldConsents.stream().filter(c -> this.cmsPsuService.isPsuDataListEqual(c.getPsuDataList(), psuDataList)).collect(Collectors.toList());
        if (oldConsentsWithExactPsuDataLists.isEmpty()) {
            return false;
        }
        oldConsentsWithExactPsuDataLists.forEach(c -> c.setConsentStatus(ConsentStatus.TERMINATED_BY_TPP));
        this.aisConsentRepository.save(oldConsentsWithExactPsuDataLists);
        return true;
    }

    @Transactional
    public void checkConsentAndSaveActionLog(AisConsentActionRequest request) {
        Optional<AisConsent> consentOpt = this.getActualAisConsent(request.getConsentId());
        if (consentOpt.isPresent()) {
            AisConsent consent = consentOpt.get();
            this.aisConsentConfirmationExpirationService.checkAndUpdateOnConfirmationExpiration(consent);
            this.checkAndUpdateOnExpiration(consent);
            this.updateAisConsentCounter(consent);
            this.logConsentAction(consent.getExternalId(), this.resolveConsentActionStatus(request, consent), request.getTppId());
        }
    }

    @Transactional
    public Optional<String> updateAspspAccountAccess(String consentId, AisAccountAccessInfo request) {
        return this.getActualAisConsent(consentId).map(consent -> {
            consent.addAspspAccountAccess(new AspspAccountAccessHolder(request).getAccountAccesses());
            return ((AisConsent)this.aisConsentRepository.save(consent)).getExternalId();
        });
    }

    @Transactional
    public Optional<String> createAuthorization(String consentId, AisConsentAuthorizationRequest request) {
        return this.aisConsentRepository.findByExternalId(consentId).filter(con -> !con.getConsentStatus().isFinalisedStatus()).map(aisConsent -> {
            this.closePreviousAuthorisationsByPsu(aisConsent.getAuthorizations(), request.getPsuData());
            return this.saveNewAuthorization((AisConsent)aisConsent, request);
        });
    }

    public Optional<AisConsentAuthorizationResponse> getAccountConsentAuthorizationById(String authorizationId, String consentId) {
        boolean consentPresent = this.aisConsentRepository.findByExternalId(consentId).filter(c -> !c.getConsentStatus().isFinalisedStatus()).isPresent();
        return consentPresent ? this.aisConsentAuthorisationRepository.findByExternalId(authorizationId).map(this.consentMapper::mapToAisConsentAuthorizationResponse) : Optional.empty();
    }

    public Optional<List<String>> getAuthorisationsByConsentId(String consentId) {
        return this.aisConsentRepository.findByExternalId(consentId).map(cst -> cst.getAuthorizations().stream().map(AisConsentAuthorization::getExternalId).collect(Collectors.toList()));
    }

    @Transactional
    public Optional<ScaStatus> getAuthorisationScaStatus(String consentId, String authorisationId) {
        Optional<AisConsent> consentOptional = this.aisConsentRepository.findByExternalId(consentId);
        if (!consentOptional.isPresent()) {
            log.info("Consent ID: [{}], Authorisation ID: [{}]. Get authorisation SCA status failed, because consent is not found", (Object)consentId, (Object)authorisationId);
            return Optional.empty();
        }
        AisConsent consent = consentOptional.get();
        if (this.aisConsentConfirmationExpirationService.isConsentConfirmationExpired(consent)) {
            this.aisConsentConfirmationExpirationService.updateConsentOnConfirmationExpiration(consent);
            log.info("Consent ID: [{}], Authorisation ID: [{}]. Get authorisation SCA status failed, because consent is expired", (Object)consentId, (Object)authorisationId);
            return Optional.of(ScaStatus.FAILED);
        }
        Optional<AisConsentAuthorization> authorisation = this.findAuthorisationInConsent(authorisationId, consent);
        return authorisation.map(AisConsentAuthorization::getScaStatus);
    }

    public boolean isAuthenticationMethodDecoupled(String authorisationId, String authenticationMethodId) {
        Optional<AisConsentAuthorization> authorisationOptional = this.aisConsentAuthorisationRepository.findByExternalId(authorisationId);
        return authorisationOptional.map(a -> a.getAvailableScaMethods().stream().filter(m -> Objects.equals(m.getAuthenticationMethodId(), authenticationMethodId)).anyMatch(ScaMethod::isDecoupled)).orElse(false);
    }

    @Transactional
    public boolean saveAuthenticationMethods(String authorisationId, List<CmsScaMethod> methods) {
        Optional<AisConsentAuthorization> authorisationOptional = this.aisConsentAuthorisationRepository.findByExternalId(authorisationId);
        if (!authorisationOptional.isPresent()) {
            log.info(" Authorisation ID: [{}]. Save authentication methods failed, because authorisation is not found", (Object)authorisationId);
            return false;
        }
        AisConsentAuthorization authorisation = authorisationOptional.get();
        authorisation.setAvailableScaMethods(this.scaMethodMapper.mapToScaMethods(methods));
        this.aisConsentAuthorisationRepository.save(authorisation);
        return true;
    }

    @Transactional
    public boolean updateConsentAuthorization(String authorisationId, AisConsentAuthorizationRequest request) {
        Optional<AisConsentAuthorization> aisConsentAuthorizationOptional = this.aisConsentAuthorisationRepository.findByExternalId(authorisationId);
        if (!aisConsentAuthorizationOptional.isPresent()) {
            log.info("Authorisation ID: [{}]. Update consent authorisation failed, because consent authorisation is not found", (Object)authorisationId);
            return false;
        }
        AisConsentAuthorization aisConsentAuthorisation = aisConsentAuthorizationOptional.get();
        if (aisConsentAuthorisation.getScaStatus().isFinalisedStatus()) {
            log.info("Authorisation ID: [{}], SCA status: [{}]. Update consent authorisation failed, because consent authorisation has finalised status", (Object)authorisationId, (Object)aisConsentAuthorisation.getScaStatus().getValue());
            return false;
        }
        if (ScaStatus.STARTED == aisConsentAuthorisation.getScaStatus()) {
            PsuData psuRequest = this.psuDataMapper.mapToPsuData(request.getPsuData());
            if (!this.isPsuDataRequestCorrect(psuRequest, aisConsentAuthorisation.getPsuData())) {
                log.info("Authorisation ID: [{}], SCA status: [{}]. Update consent authorisation failed, because psu data request does not match stored psu data", (Object)authorisationId, (Object)aisConsentAuthorisation.getScaStatus().getValue());
                return false;
            }
            AisConsent aisConsent = aisConsentAuthorisation.getConsent();
            Optional<PsuData> psuDataOptional = this.cmsPsuService.definePsuDataForAuthorisation(psuRequest, aisConsent.getPsuDataList());
            if (psuDataOptional.isPresent()) {
                PsuData psuData = psuDataOptional.get();
                aisConsent.setPsuDataList(this.cmsPsuService.enrichPsuData(psuData, aisConsent.getPsuDataList()));
                aisConsentAuthorisation.setPsuData(psuData);
            }
            aisConsentAuthorisation.setConsent(aisConsent);
        }
        if (ScaStatus.SCAMETHODSELECTED == request.getScaStatus()) {
            aisConsentAuthorisation.setAuthenticationMethodId(request.getAuthenticationMethodId());
        }
        aisConsentAuthorisation.setScaStatus(request.getScaStatus());
        aisConsentAuthorisation = (AisConsentAuthorization)this.aisConsentAuthorisationRepository.save(aisConsentAuthorisation);
        return aisConsentAuthorisation.getExternalId() != null;
    }

    public Optional<List<PsuIdData>> getPsuDataByConsentId(String consentId) {
        return this.getActualAisConsent(consentId).map(ac -> this.psuDataMapper.mapToPsuIdDataList(ac.getPsuDataList()));
    }

    @Transactional
    public boolean updateScaApproach(String authorisationId, ScaApproach scaApproach) {
        Optional<AisConsentAuthorization> aisConsentAuthorisationOptional = this.aisConsentAuthorisationRepository.findByExternalId(authorisationId);
        if (!aisConsentAuthorisationOptional.isPresent()) {
            log.info("Authorisation ID: [{}]. Update SCA approach failed, because consent authorisation is not found", (Object)authorisationId);
            return false;
        }
        AisConsentAuthorization aisConsentAuthorisation = aisConsentAuthorisationOptional.get();
        aisConsentAuthorisation.setScaApproach(scaApproach);
        this.aisConsentAuthorisationRepository.save(aisConsentAuthorisation);
        return true;
    }

    @Transactional
    public boolean updateMultilevelScaRequired(String consentId, boolean multilevelScaRequired) {
        Optional<AisConsent> aisConsentOptional = this.aisConsentRepository.findByExternalId(consentId);
        if (!aisConsentOptional.isPresent()) {
            return false;
        }
        AisConsent consent = aisConsentOptional.get();
        consent.setMultilevelScaRequired(multilevelScaRequired);
        this.aisConsentRepository.save(consent);
        return true;
    }

    private AisConsent createConsentFromRequest(CreateAisConsentRequest request) {
        AisConsent consent = new AisConsent();
        consent.setConsentStatus(ConsentStatus.RECEIVED);
        consent.setAllowedFrequencyPerDay(request.getAllowedFrequencyPerDay());
        consent.setTppFrequencyPerDay(request.getRequestedFrequencyPerDay());
        consent.setUsageCounter(request.getAllowedFrequencyPerDay());
        consent.setRequestDateTime(LocalDateTime.now());
        consent.setExpireDate(request.getValidUntil());
        consent.setPsuDataList(this.psuDataMapper.mapToPsuDataList(Collections.singletonList(request.getPsuData())));
        consent.setTppInfo(this.tppInfoMapper.mapToTppInfoEntity(request.getTppInfo()));
        consent.addAccountAccess(new TppAccountAccessHolder(request.getAccess()).getAccountAccesses());
        consent.setRecurringIndicator(request.isRecurringIndicator());
        consent.setTppRedirectPreferred(request.isTppRedirectPreferred());
        consent.setCombinedServiceIndicator(request.isCombinedServiceIndicator());
        consent.setAisConsentRequestType(this.getRequestTypeFromAccess(request.getAccess()));
        consent.setAvailableAccounts(request.getAccess().getAvailableAccounts());
        consent.setAllPsd2(request.getAccess().getAllPsd2());
        return consent;
    }

    private AisConsentRequestType getRequestTypeFromAccess(AisAccountAccessInfo accessInfo) {
        if (accessInfo.getAllPsd2() == AccountAccessType.ALL_ACCOUNTS) {
            return AisConsentRequestType.GLOBAL;
        }
        if (EnumSet.of(AccountAccessType.ALL_ACCOUNTS, AccountAccessType.ALL_ACCOUNTS_WITH_BALANCES).contains(accessInfo.getAvailableAccounts())) {
            return AisConsentRequestType.ALL_AVAILABLE_ACCOUNTS;
        }
        if (this.isEmptyAccess(accessInfo)) {
            return AisConsentRequestType.BANK_OFFERED;
        }
        return AisConsentRequestType.DEDICATED_ACCOUNTS;
    }

    private boolean isEmptyAccess(AisAccountAccessInfo accessInfo) {
        return CollectionUtils.isEmpty((Collection)accessInfo.getAccounts()) && CollectionUtils.isEmpty((Collection)accessInfo.getBalances()) && CollectionUtils.isEmpty((Collection)accessInfo.getTransactions());
    }

    private ActionStatus resolveConsentActionStatus(AisConsentActionRequest request, AisConsent consent) {
        return consent == null ? ActionStatus.BAD_PAYLOAD : request.getActionStatus();
    }

    private void updateAisConsentCounter(AisConsent consent) {
        if (consent != null && consent.hasUsagesAvailable()) {
            int usageCounter = consent.getUsageCounter();
            int newUsageCounter = --usageCounter;
            consent.setUsageCounter(newUsageCounter);
            consent.setLastActionDate(LocalDate.now());
            this.aisConsentRepository.save(consent);
        }
    }

    private void logConsentAction(String requestedConsentId, ActionStatus actionStatus, String tppId) {
        AisConsentAction action = new AisConsentAction();
        action.setActionStatus(actionStatus);
        action.setRequestedConsentId(requestedConsentId);
        action.setTppId(tppId);
        action.setRequestDate(LocalDate.now());
        this.aisConsentActionRepository.save(action);
    }

    private Optional<AisConsent> getActualAisConsent(String consentId) {
        return this.aisConsentRepository.findByExternalId(consentId).filter(c -> !c.getConsentStatus().isFinalisedStatus());
    }

    private AisConsent checkAndUpdateOnExpiration(AisConsent consent) {
        if (consent != null && consent.isExpiredByDate() && consent.isStatusNotExpired()) {
            consent.setConsentStatus(ConsentStatus.EXPIRED);
            consent.setExpireDate(LocalDate.now());
            consent.setLastActionDate(LocalDate.now());
            this.aisConsentRepository.save(consent);
        }
        return consent;
    }

    private boolean setStatusAndSaveConsent(AisConsent consent, ConsentStatus status) {
        if (consent.getConsentStatus().isFinalisedStatus()) {
            log.info("Consent ID: [{}], Consent status [{}]. Update consent status by ID failed, because consent status is finalised", (Object)consent.getExternalId(), (Object)consent.getConsentStatus());
            return false;
        }
        consent.setLastActionDate(LocalDate.now());
        consent.setConsentStatus(status);
        return Optional.ofNullable(this.aisConsentRepository.save(consent)).isPresent();
    }

    private String saveNewAuthorization(AisConsent aisConsent, AisConsentAuthorizationRequest request) {
        AisConsentAuthorization consentAuthorization = new AisConsentAuthorization();
        Optional<PsuData> psuDataOptional = this.cmsPsuService.definePsuDataForAuthorisation(this.psuDataMapper.mapToPsuData(request.getPsuData()), aisConsent.getPsuDataList());
        if (psuDataOptional.isPresent()) {
            PsuData psuData = psuDataOptional.get();
            aisConsent.setPsuDataList(this.cmsPsuService.enrichPsuData(psuData, aisConsent.getPsuDataList()));
            consentAuthorization.setPsuData(psuData);
        }
        consentAuthorization.setExternalId(UUID.randomUUID().toString());
        consentAuthorization.setConsent(aisConsent);
        consentAuthorization.setScaStatus(request.getScaStatus());
        consentAuthorization.setRedirectUrlExpirationTimestamp(OffsetDateTime.now().plus(this.aspspProfileService.getAspspSettings().getRedirectUrlExpirationTimeMs(), ChronoUnit.MILLIS));
        consentAuthorization.setScaApproach(request.getScaApproach());
        return ((AisConsentAuthorization)this.aisConsentAuthorisationRepository.save(consentAuthorization)).getExternalId();
    }

    private Optional<AisConsentAuthorization> findAuthorisationInConsent(String authorisationId, AisConsent consent) {
        return consent.getAuthorizations().stream().filter(auth -> auth.getExternalId().equals(authorisationId)).findFirst();
    }

    private void closePreviousAuthorisationsByPsu(List<AisConsentAuthorization> authorisations, PsuIdData psuIdData) {
        PsuData psuData = this.psuDataMapper.mapToPsuData(psuIdData);
        if (Objects.isNull(psuData) || psuData.isEmpty()) {
            return;
        }
        List aisConsentAuthorisations = authorisations.stream().filter(auth -> Objects.nonNull(auth.getPsuData()) && auth.getPsuData().contentEquals(psuData)).map(this::makeAuthorisationFailedAndExpired).collect(Collectors.toList());
        this.aisConsentAuthorisationRepository.save(aisConsentAuthorisations);
    }

    private AisConsentAuthorization makeAuthorisationFailedAndExpired(AisConsentAuthorization auth) {
        auth.setScaStatus(ScaStatus.FAILED);
        auth.setRedirectUrlExpirationTimestamp(OffsetDateTime.now());
        return auth;
    }

    private boolean isPsuDataRequestCorrect(PsuData psuRequest, PsuData psuAuth) {
        return Optional.ofNullable(psuRequest).map(psu -> psuAuth == null || psu.contentEquals(psuAuth)).orElse(false);
    }

    @ConstructorProperties(value={"aisConsentRepository", "aisConsentActionRepository", "aisConsentAuthorisationRepository", "consentMapper", "psuDataMapper", "aspspProfileService", "aisConsentConfirmationExpirationService", "tppInfoMapper", "scaMethodMapper", "cmsPsuService"})
    public AisConsentServiceInternal(AisConsentRepository aisConsentRepository, AisConsentActionRepository aisConsentActionRepository, AisConsentAuthorisationRepository aisConsentAuthorisationRepository, AisConsentMapper consentMapper, PsuDataMapper psuDataMapper, AspspProfileService aspspProfileService, AisConsentConfirmationExpirationService aisConsentConfirmationExpirationService, TppInfoMapper tppInfoMapper, ScaMethodMapper scaMethodMapper, CmsPsuService cmsPsuService) {
        this.aisConsentRepository = aisConsentRepository;
        this.aisConsentActionRepository = aisConsentActionRepository;
        this.aisConsentAuthorisationRepository = aisConsentAuthorisationRepository;
        this.consentMapper = consentMapper;
        this.psuDataMapper = psuDataMapper;
        this.aspspProfileService = aspspProfileService;
        this.aisConsentConfirmationExpirationService = aisConsentConfirmationExpirationService;
        this.tppInfoMapper = tppInfoMapper;
        this.scaMethodMapper = scaMethodMapper;
        this.cmsPsuService = cmsPsuService;
    }
}

