/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.repository.specification;

import de.adorsys.psd2.consent.domain.account.AisConsent;
import de.adorsys.psd2.consent.repository.specification.EntityAttributeSpecificationProvider;
import de.adorsys.psd2.consent.repository.specification.GenericSpecification;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import java.time.LocalDate;
import javax.persistence.criteria.Join;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.domain.Specifications;
import org.springframework.stereotype.Service;

@Service
public class AisConsentSpecification
extends GenericSpecification {
    public Specification<AisConsent> byConsentIdAndInstanceId(String consentId, String instanceId) {
        return Specifications.where(this.byInstanceId(instanceId)).and(EntityAttributeSpecificationProvider.provideSpecificationForEntityAttribute("externalId", consentId));
    }

    public Specification<AisConsent> byTppIdAndCreationPeriodAndPsuIdDataAndInstanceId(@NotNull String tppAuthorisationNumber, @Nullable LocalDate createDateFrom, @Nullable LocalDate createDateTo, @Nullable PsuIdData psuIdData, @Nullable String instanceId) {
        return Specifications.where(this.byTppAuthorisationNumber(tppAuthorisationNumber)).and(this.byCreationTimestamp(createDateFrom, createDateTo)).and(this.byPsuIdDataInList(psuIdData)).and(this.byInstanceId(instanceId));
    }

    public Specification<AisConsent> byPsuIdDataAndCreationPeriodAndInstanceId(@NotNull PsuIdData psuIdData, @Nullable LocalDate createDateFrom, @Nullable LocalDate createDateTo, @Nullable String instanceId) {
        return Specifications.where(this.byPsuIdDataInList(psuIdData)).and(this.byCreationTimestamp(createDateFrom, createDateTo)).and(this.byInstanceId(instanceId));
    }

    public Specification<AisConsent> byAspspAccountIdAndCreationPeriodAndInstanceId(@NotNull String aspspAccountId, @Nullable LocalDate createDateFrom, @Nullable LocalDate createDateTo, @Nullable String instanceId) {
        return Specifications.where(this.byAspspAccountIdInAspspAccountAccess(aspspAccountId)).and(this.byCreationTimestamp(createDateFrom, createDateTo)).and(this.byInstanceId(instanceId));
    }

    private <T> Specification<T> byAspspAccountIdInAspspAccountAccess(@Nullable String aspspAccountId) {
        return (root, query, cb) -> {
            Join aspspAccountAccessJoin = root.join("aspspAccountAccesses");
            query.distinct(true);
            return EntityAttributeSpecificationProvider.provideSpecificationForJoinedEntityAttribute(aspspAccountAccessJoin, "aspspAccountId", aspspAccountId).toPredicate(root, query, cb);
        };
    }
}

