/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.domain.event;

import de.adorsys.psd2.consent.domain.InstanceDependableEntity;
import de.adorsys.psd2.xs2a.core.event.EventOrigin;
import de.adorsys.psd2.xs2a.core.event.EventType;
import java.time.OffsetDateTime;
import java.util.Arrays;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.SequenceGenerator;

@Entity(name="event")
public class EventEntity
extends InstanceDependableEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="event_generator")
    @SequenceGenerator(name="event_generator", sequenceName="event_id_seq")
    private Long id;
    @Column(name="timestamp", nullable=false)
    private OffsetDateTime timestamp;
    @Column(name="consent_id")
    private String consentId;
    @Column(name="payment_id")
    private String paymentId;
    @Lob
    @Column(name="payload")
    private byte[] payload;
    @Column(name="event_origin", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private EventOrigin eventOrigin;
    @Column(name="event_type", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private EventType eventType;

    public Long getId() {
        return this.id;
    }

    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    public String getConsentId() {
        return this.consentId;
    }

    public String getPaymentId() {
        return this.paymentId;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public EventOrigin getEventOrigin() {
        return this.eventOrigin;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
    }

    public void setConsentId(String consentId) {
        this.consentId = consentId;
    }

    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }

    public void setPayload(byte[] payload) {
        this.payload = payload;
    }

    public void setEventOrigin(EventOrigin eventOrigin) {
        this.eventOrigin = eventOrigin;
    }

    public void setEventType(EventType eventType) {
        this.eventType = eventType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventEntity)) {
            return false;
        }
        EventEntity other = (EventEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        OffsetDateTime this$timestamp = this.getTimestamp();
        OffsetDateTime other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        String this$consentId = this.getConsentId();
        String other$consentId = other.getConsentId();
        if (this$consentId == null ? other$consentId != null : !this$consentId.equals(other$consentId)) {
            return false;
        }
        String this$paymentId = this.getPaymentId();
        String other$paymentId = other.getPaymentId();
        if (this$paymentId == null ? other$paymentId != null : !this$paymentId.equals(other$paymentId)) {
            return false;
        }
        if (!Arrays.equals(this.getPayload(), other.getPayload())) {
            return false;
        }
        EventOrigin this$eventOrigin = this.getEventOrigin();
        EventOrigin other$eventOrigin = other.getEventOrigin();
        if (this$eventOrigin == null ? other$eventOrigin != null : !this$eventOrigin.equals(other$eventOrigin)) {
            return false;
        }
        EventType this$eventType = this.getEventType();
        EventType other$eventType = other.getEventType();
        return !(this$eventType == null ? other$eventType != null : !this$eventType.equals(other$eventType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EventEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        OffsetDateTime $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        String $consentId = this.getConsentId();
        result = result * 59 + ($consentId == null ? 43 : $consentId.hashCode());
        String $paymentId = this.getPaymentId();
        result = result * 59 + ($paymentId == null ? 43 : $paymentId.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPayload());
        EventOrigin $eventOrigin = this.getEventOrigin();
        result = result * 59 + ($eventOrigin == null ? 43 : $eventOrigin.hashCode());
        EventType $eventType = this.getEventType();
        result = result * 59 + ($eventType == null ? 43 : $eventType.hashCode());
        return result;
    }

    public String toString() {
        return "EventEntity(id=" + this.getId() + ", timestamp=" + this.getTimestamp() + ", consentId=" + this.getConsentId() + ", paymentId=" + this.getPaymentId() + ", payload=" + Arrays.toString(this.getPayload()) + ", eventOrigin=" + this.getEventOrigin() + ", eventType=" + this.getEventType() + ")";
    }
}

