/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.api.service.UpdatePaymentStatusAfterSpiService;
import de.adorsys.psd2.consent.domain.payment.PisCommonPaymentData;
import de.adorsys.psd2.consent.service.CommonPaymentDataService;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class UpdatePaymentStatusAfterSpiServiceInternal
implements UpdatePaymentStatusAfterSpiService {
    private static final Logger log = LoggerFactory.getLogger(UpdatePaymentStatusAfterSpiServiceInternal.class);
    private final CommonPaymentDataService commonPaymentDataService;

    @Transactional
    public boolean updatePaymentStatus(@NotNull String paymentId, @NotNull TransactionStatus status) {
        Optional<PisCommonPaymentData> paymentDataOptional = this.commonPaymentDataService.getPisCommonPaymentData(paymentId, null);
        if (!paymentDataOptional.isPresent() || paymentDataOptional.get().isFinalised()) {
            return false;
        }
        return this.commonPaymentDataService.updateStatusInPaymentData(paymentDataOptional.get(), status);
    }

    @ConstructorProperties(value={"commonPaymentDataService"})
    public UpdatePaymentStatusAfterSpiServiceInternal(CommonPaymentDataService commonPaymentDataService) {
        this.commonPaymentDataService = commonPaymentDataService;
    }
}

