/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.aspsp.profile.service.AspspProfileService;
import de.adorsys.psd2.consent.api.CmsAuthorisationType;
import de.adorsys.psd2.consent.api.CmsScaMethod;
import de.adorsys.psd2.consent.api.pis.CreatePisCommonPaymentResponse;
import de.adorsys.psd2.consent.api.pis.authorisation.CreatePisAuthorisationRequest;
import de.adorsys.psd2.consent.api.pis.authorisation.CreatePisAuthorisationResponse;
import de.adorsys.psd2.consent.api.pis.authorisation.GetPisAuthorisationResponse;
import de.adorsys.psd2.consent.api.pis.authorisation.UpdatePisCommonPaymentPsuDataRequest;
import de.adorsys.psd2.consent.api.pis.authorisation.UpdatePisCommonPaymentPsuDataResponse;
import de.adorsys.psd2.consent.api.pis.proto.PisCommonPaymentRequest;
import de.adorsys.psd2.consent.api.pis.proto.PisCommonPaymentResponse;
import de.adorsys.psd2.consent.api.pis.proto.PisPaymentInfo;
import de.adorsys.psd2.consent.api.service.PisCommonPaymentService;
import de.adorsys.psd2.consent.domain.PsuData;
import de.adorsys.psd2.consent.domain.ScaMethod;
import de.adorsys.psd2.consent.domain.payment.PisAuthorization;
import de.adorsys.psd2.consent.domain.payment.PisCommonPaymentData;
import de.adorsys.psd2.consent.domain.payment.PisPaymentData;
import de.adorsys.psd2.consent.repository.PisAuthorisationRepository;
import de.adorsys.psd2.consent.repository.PisCommonPaymentDataRepository;
import de.adorsys.psd2.consent.repository.PisPaymentDataRepository;
import de.adorsys.psd2.consent.service.PisCommonPaymentConfirmationExpirationService;
import de.adorsys.psd2.consent.service.mapper.PisCommonPaymentMapper;
import de.adorsys.psd2.consent.service.mapper.PsuDataMapper;
import de.adorsys.psd2.consent.service.mapper.ScaMethodMapper;
import de.adorsys.psd2.consent.service.psu.CmsPsuService;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import java.beans.ConstructorProperties;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class PisCommonPaymentServiceInternal
implements PisCommonPaymentService {
    private static final Logger log = LoggerFactory.getLogger(PisCommonPaymentServiceInternal.class);
    private final PisCommonPaymentMapper pisCommonPaymentMapper;
    private final PsuDataMapper psuDataMapper;
    private final PisAuthorisationRepository pisAuthorisationRepository;
    private final PisPaymentDataRepository pisPaymentDataRepository;
    private final PisCommonPaymentDataRepository pisCommonPaymentDataRepository;
    private final AspspProfileService aspspProfileService;
    private final PisCommonPaymentConfirmationExpirationService pisCommonPaymentConfirmationExpirationService;
    private final ScaMethodMapper scaMethodMapper;
    private final CmsPsuService cmsPsuService;

    @Transactional
    public Optional<CreatePisCommonPaymentResponse> createCommonPayment(PisPaymentInfo request) {
        PisCommonPaymentData commonPaymentData = this.pisCommonPaymentMapper.mapToPisCommonPaymentData(request);
        PisCommonPaymentData saved = (PisCommonPaymentData)this.pisCommonPaymentDataRepository.save(commonPaymentData);
        if (saved.getId() == null) {
            return Optional.empty();
        }
        return Optional.of(new CreatePisCommonPaymentResponse(saved.getPaymentId()));
    }

    @Transactional
    public Optional<TransactionStatus> getPisCommonPaymentStatusById(String paymentId) {
        return this.pisCommonPaymentDataRepository.findByPaymentId(paymentId).map(this.pisCommonPaymentConfirmationExpirationService::checkAndUpdatePaymentDataOnConfirmationExpiration).map(PisCommonPaymentData::getTransactionStatus);
    }

    @Transactional
    public Optional<PisCommonPaymentResponse> getCommonPaymentById(String paymentId) {
        return this.pisCommonPaymentDataRepository.findByPaymentId(paymentId).map(this.pisCommonPaymentConfirmationExpirationService::checkAndUpdatePaymentDataOnConfirmationExpiration).flatMap(this.pisCommonPaymentMapper::mapToPisCommonPaymentResponse);
    }

    @Transactional
    public Optional<Boolean> updateCommonPaymentStatusById(String paymentId, TransactionStatus status) {
        return this.pisCommonPaymentDataRepository.findByPaymentId(paymentId).map(this.pisCommonPaymentConfirmationExpirationService::checkAndUpdatePaymentDataOnConfirmationExpiration).filter(pm -> !pm.getTransactionStatus().isFinalisedStatus()).map(pmt -> this.setStatusAndSaveCommonPaymentData((PisCommonPaymentData)pmt, status)).map(con -> con.getTransactionStatus() == status);
    }

    @Transactional
    public Optional<CreatePisAuthorisationResponse> createAuthorization(String paymentId, CreatePisAuthorisationRequest request) {
        return this.readReceivedCommonPaymentDataByPaymentId(paymentId).map(pmt -> {
            this.closePreviousAuthorisationsByPsu(pmt.getAuthorizations(), request.getAuthorizationType(), request.getPsuData());
            return this.saveNewAuthorisation((PisCommonPaymentData)pmt, request);
        }).map(c -> new CreatePisAuthorisationResponse(c.getExternalId()));
    }

    @Transactional
    public Optional<CreatePisAuthorisationResponse> createAuthorizationCancellation(String paymentId, CreatePisAuthorisationRequest request) {
        return this.readPisCommonPaymentDataByPaymentId(paymentId).filter(p -> p.getTransactionStatus().isNotFinalisedStatus()).map(pmt -> {
            this.closePreviousAuthorisationsByPsu(pmt.getAuthorizations(), request.getAuthorizationType(), request.getPsuData());
            return this.saveNewAuthorisation((PisCommonPaymentData)pmt, request);
        }).map(c -> new CreatePisAuthorisationResponse(c.getExternalId()));
    }

    @Transactional
    public Optional<UpdatePisCommonPaymentPsuDataResponse> updatePisAuthorisation(String authorisationId, UpdatePisCommonPaymentPsuDataRequest request) {
        Optional<PisAuthorization> pisAuthorisationOptional = this.pisAuthorisationRepository.findByExternalIdAndAuthorizationType(authorisationId, CmsAuthorisationType.CREATED);
        if (pisAuthorisationOptional.isPresent()) {
            ScaStatus scaStatus = this.doUpdateConsentAuthorisation(request, pisAuthorisationOptional.get());
            return Optional.of(new UpdatePisCommonPaymentPsuDataResponse(scaStatus));
        }
        return Optional.empty();
    }

    @Transactional
    public Optional<UpdatePisCommonPaymentPsuDataResponse> updatePisCancellationAuthorisation(String cancellationId, UpdatePisCommonPaymentPsuDataRequest request) {
        Optional<PisAuthorization> pisAuthorisationOptional = this.pisAuthorisationRepository.findByExternalIdAndAuthorizationType(cancellationId, CmsAuthorisationType.CANCELLED);
        if (pisAuthorisationOptional.isPresent()) {
            ScaStatus scaStatus = this.doUpdateConsentAuthorisation(request, pisAuthorisationOptional.get());
            return Optional.of(new UpdatePisCommonPaymentPsuDataResponse(scaStatus));
        }
        return Optional.empty();
    }

    @Transactional
    public void updateCommonPayment(PisCommonPaymentRequest request, String paymentId) {
        Optional<PisCommonPaymentData> pisCommonPaymentById = this.pisCommonPaymentDataRepository.findByPaymentId(paymentId);
        pisCommonPaymentById.ifPresent(commonPayment -> this.savePaymentData((PisCommonPaymentData)commonPayment, request));
    }

    public Optional<GetPisAuthorisationResponse> getPisAuthorisationById(String authorisationId) {
        return this.pisAuthorisationRepository.findByExternalIdAndAuthorizationType(authorisationId, CmsAuthorisationType.CREATED).map(this.pisCommonPaymentMapper::mapToGetPisAuthorizationResponse);
    }

    public Optional<GetPisAuthorisationResponse> getPisCancellationAuthorisationById(String cancellationId) {
        return this.pisAuthorisationRepository.findByExternalIdAndAuthorizationType(cancellationId, CmsAuthorisationType.CANCELLED).map(this.pisCommonPaymentMapper::mapToGetPisAuthorizationResponse);
    }

    public Optional<List<String>> getAuthorisationsByPaymentId(String paymentId, CmsAuthorisationType authorisationType) {
        return this.readReceivedCommonPaymentDataByPaymentId(paymentId).map(pmt -> this.readAuthorisationsFromPaymentCommonData((PisCommonPaymentData)pmt, authorisationType));
    }

    @Transactional
    public Optional<ScaStatus> getAuthorisationScaStatus(@NotNull String paymentId, @NotNull String authorisationId, CmsAuthorisationType authorisationType) {
        Optional<PisAuthorization> authorisationOptional = this.pisAuthorisationRepository.findByExternalIdAndAuthorizationType(authorisationId, authorisationType);
        if (!authorisationOptional.isPresent()) {
            return Optional.empty();
        }
        PisCommonPaymentData paymentData = authorisationOptional.get().getPaymentData();
        if (this.pisCommonPaymentConfirmationExpirationService.isPaymentDataOnConfirmationExpired(paymentData)) {
            this.pisCommonPaymentConfirmationExpirationService.updatePaymentDataOnConfirmationExpiration(paymentData);
            return Optional.of(ScaStatus.FAILED);
        }
        return authorisationOptional.filter(auth -> paymentId.equals(auth.getPaymentData().getPaymentId())).map(PisAuthorization::getScaStatus);
    }

    public Optional<List<PsuIdData>> getPsuDataListByPaymentId(String paymentId) {
        return this.readPisCommonPaymentDataByPaymentId(paymentId).map(pc -> this.psuDataMapper.mapToPsuIdDataList(pc.getPsuDataList()));
    }

    public boolean isAuthenticationMethodDecoupled(String authorisationId, String authenticationMethodId) {
        Optional<PisAuthorization> authorisationOptional = this.pisAuthorisationRepository.findByExternalId(authorisationId);
        return authorisationOptional.map(a -> a.getAvailableScaMethods().stream().filter(m -> Objects.equals(m.getAuthenticationMethodId(), authenticationMethodId)).anyMatch(ScaMethod::isDecoupled)).orElse(false);
    }

    @Transactional
    public boolean saveAuthenticationMethods(String authorisationId, List<CmsScaMethod> methods) {
        Optional<PisAuthorization> authorisationOptional = this.pisAuthorisationRepository.findByExternalId(authorisationId);
        if (!authorisationOptional.isPresent()) {
            return false;
        }
        PisAuthorization authorisation = authorisationOptional.get();
        authorisation.setAvailableScaMethods(this.scaMethodMapper.mapToScaMethods(methods));
        this.pisAuthorisationRepository.save(authorisation);
        return true;
    }

    @Transactional
    public boolean updateScaApproach(String authorisationId, ScaApproach scaApproach) {
        Optional<PisAuthorization> authorisationOptional = this.pisAuthorisationRepository.findByExternalId(authorisationId);
        if (!authorisationOptional.isPresent()) {
            return false;
        }
        PisAuthorization authorisation = authorisationOptional.get();
        authorisation.setScaApproach(scaApproach);
        this.pisAuthorisationRepository.save(authorisation);
        return true;
    }

    private PisCommonPaymentData setStatusAndSaveCommonPaymentData(PisCommonPaymentData commonPaymentData, TransactionStatus status) {
        commonPaymentData.setTransactionStatus(status);
        return (PisCommonPaymentData)this.pisCommonPaymentDataRepository.save(commonPaymentData);
    }

    private Optional<PisCommonPaymentData> readReceivedCommonPaymentDataByPaymentId(String paymentId) {
        Optional<PisCommonPaymentData> commonPaymentData = this.pisPaymentDataRepository.findByPaymentIdAndPaymentDataTransactionStatusIn(paymentId, Arrays.asList(TransactionStatus.RCVD, TransactionStatus.PATC)).filter(CollectionUtils::isNotEmpty).map(list -> ((PisPaymentData)list.get(0)).getPaymentData()).map(this.pisCommonPaymentConfirmationExpirationService::checkAndUpdatePaymentDataOnConfirmationExpiration).filter(p -> EnumSet.of(TransactionStatus.RCVD, TransactionStatus.PATC).contains(p.getTransactionStatus()));
        if (!commonPaymentData.isPresent()) {
            commonPaymentData = this.pisCommonPaymentDataRepository.findByPaymentIdAndTransactionStatusIn(paymentId, Arrays.asList(TransactionStatus.RCVD, TransactionStatus.PATC)).map(this.pisCommonPaymentConfirmationExpirationService::checkAndUpdatePaymentDataOnConfirmationExpiration).filter(p -> EnumSet.of(TransactionStatus.RCVD, TransactionStatus.PATC).contains(p.getTransactionStatus()));
        }
        return commonPaymentData;
    }

    private Optional<PisCommonPaymentData> readPisCommonPaymentDataByPaymentId(String paymentId) {
        Optional<PisCommonPaymentData> commonPaymentData = this.pisPaymentDataRepository.findByPaymentId(paymentId).filter(CollectionUtils::isNotEmpty).map(list -> ((PisPaymentData)list.get(0)).getPaymentData());
        if (!commonPaymentData.isPresent()) {
            commonPaymentData = this.pisCommonPaymentDataRepository.findByPaymentId(paymentId);
        }
        return commonPaymentData;
    }

    private void savePaymentData(PisCommonPaymentData pisCommonPayment, PisCommonPaymentRequest request) {
        boolean isCommonPayment;
        boolean bl = isCommonPayment = CollectionUtils.isEmpty((Collection)request.getPayments()) && request.getPaymentInfo() != null;
        if (isCommonPayment) {
            this.pisCommonPaymentDataRepository.save(this.pisCommonPaymentMapper.mapToPisCommonPaymentData(request.getPaymentInfo()));
        } else {
            this.pisPaymentDataRepository.save(this.pisCommonPaymentMapper.mapToPisPaymentDataList(request.getPayments(), pisCommonPayment));
        }
    }

    private PisAuthorization saveNewAuthorisation(PisCommonPaymentData paymentData, CreatePisAuthorisationRequest request) {
        PisAuthorization consentAuthorisation = new PisAuthorization();
        Optional<PsuData> psuDataOptional = this.cmsPsuService.definePsuDataForAuthorisation(this.psuDataMapper.mapToPsuData(request.getPsuData()), paymentData.getPsuDataList());
        if (psuDataOptional.isPresent()) {
            PsuData psuData = psuDataOptional.get();
            paymentData.setPsuDataList(this.cmsPsuService.enrichPsuData(psuData, paymentData.getPsuDataList()));
            consentAuthorisation.setPsuData(psuData);
        }
        consentAuthorisation.setExternalId(UUID.randomUUID().toString());
        consentAuthorisation.setScaStatus(ScaStatus.STARTED);
        consentAuthorisation.setAuthorizationType(request.getAuthorizationType());
        consentAuthorisation.setRedirectUrlExpirationTimestamp(this.countRedirectUrlExpirationTimestampForAuthorisationType(request.getAuthorizationType()));
        consentAuthorisation.setScaApproach(request.getScaApproach());
        consentAuthorisation.setPaymentData(paymentData);
        return (PisAuthorization)this.pisAuthorisationRepository.save(consentAuthorisation);
    }

    private OffsetDateTime countRedirectUrlExpirationTimestampForAuthorisationType(CmsAuthorisationType authorisationType) {
        long redirectUrlExpirationTimeMs = authorisationType == CmsAuthorisationType.CANCELLED ? this.aspspProfileService.getAspspSettings().getPaymentCancellationRedirectUrlExpirationTimeMs() : this.aspspProfileService.getAspspSettings().getRedirectUrlExpirationTimeMs();
        return OffsetDateTime.now().plus(redirectUrlExpirationTimeMs, ChronoUnit.MILLIS);
    }

    private void closePreviousAuthorisationsByPsu(List<PisAuthorization> authorisations, CmsAuthorisationType authorisationType, PsuIdData psuIdData) {
        PsuData psuData = this.psuDataMapper.mapToPsuData(psuIdData);
        if (Objects.isNull(psuData) || psuData.isEmpty()) {
            return;
        }
        List pisAuthorisationList = authorisations.stream().filter(auth -> auth.getAuthorizationType() == authorisationType).filter(auth -> Objects.nonNull(auth.getPsuData()) && auth.getPsuData().contentEquals(psuData)).map(this::makeAuthorisationFailedAndExpired).collect(Collectors.toList());
        this.pisAuthorisationRepository.save(pisAuthorisationList);
    }

    private PisAuthorization makeAuthorisationFailedAndExpired(PisAuthorization auth) {
        auth.setScaStatus(ScaStatus.FAILED);
        auth.setRedirectUrlExpirationTimestamp(OffsetDateTime.now());
        return auth;
    }

    private List<String> readAuthorisationsFromPaymentCommonData(PisCommonPaymentData paymentData, CmsAuthorisationType authorisationType) {
        return paymentData.getAuthorizations().stream().filter(auth -> auth.getAuthorizationType() == authorisationType).map(PisAuthorization::getExternalId).collect(Collectors.toList());
    }

    private ScaStatus doUpdateConsentAuthorisation(UpdatePisCommonPaymentPsuDataRequest request, PisAuthorization pisAuthorisation) {
        String chosenMethod;
        if (pisAuthorisation.getScaStatus().isFinalisedStatus()) {
            return pisAuthorisation.getScaStatus();
        }
        PsuData psuDataInAuthorisation = pisAuthorisation.getPsuData();
        PsuData psuDataInRequest = this.psuDataMapper.mapToPsuData(request.getPsuData());
        if (ScaStatus.STARTED == pisAuthorisation.getScaStatus()) {
            if (!this.cmsPsuService.isPsuDataRequestCorrect(psuDataInRequest, psuDataInAuthorisation)) {
                log.info("Authorisation ID: [{}], SCA status: [{}]. Update consent authorisation failed, because psu data request does not match stored psu data", (Object)pisAuthorisation.getExternalId(), (Object)pisAuthorisation.getScaStatus().getValue());
                return pisAuthorisation.getScaStatus();
            }
            PisCommonPaymentData paymentData = pisAuthorisation.getPaymentData();
            List<PsuData> psuListInPayment = paymentData.getPsuDataList();
            Optional<PsuData> psuDataOptional = this.cmsPsuService.definePsuDataForAuthorisation(psuDataInRequest, psuListInPayment);
            if (psuDataOptional.isPresent()) {
                PsuData psuData = psuDataOptional.get();
                paymentData.setPsuDataList(this.cmsPsuService.enrichPsuData(psuData, psuListInPayment));
                pisAuthorisation.setPsuData(psuData);
            }
        } else {
            boolean isPsuCorrect;
            boolean bl = isPsuCorrect = Objects.nonNull(psuDataInAuthorisation) && Objects.nonNull(psuDataInRequest) && psuDataInAuthorisation.contentEquals(psuDataInRequest);
            if (!isPsuCorrect) {
                log.info("Authorisation ID: [{}], SCA status: [{}]. Update consent authorisation failed, because psu data request does not match stored psu data", (Object)pisAuthorisation.getExternalId(), (Object)pisAuthorisation.getScaStatus().getValue());
                return pisAuthorisation.getScaStatus();
            }
        }
        if (ScaStatus.SCAMETHODSELECTED == request.getScaStatus() && StringUtils.isNotBlank((CharSequence)(chosenMethod = request.getAuthenticationMethodId()))) {
            pisAuthorisation.setChosenScaMethod(chosenMethod);
        }
        pisAuthorisation.setScaStatus(request.getScaStatus());
        PisAuthorization saved = (PisAuthorization)this.pisAuthorisationRepository.save(pisAuthorisation);
        return saved.getScaStatus();
    }

    @ConstructorProperties(value={"pisCommonPaymentMapper", "psuDataMapper", "pisAuthorisationRepository", "pisPaymentDataRepository", "pisCommonPaymentDataRepository", "aspspProfileService", "pisCommonPaymentConfirmationExpirationService", "scaMethodMapper", "cmsPsuService"})
    public PisCommonPaymentServiceInternal(PisCommonPaymentMapper pisCommonPaymentMapper, PsuDataMapper psuDataMapper, PisAuthorisationRepository pisAuthorisationRepository, PisPaymentDataRepository pisPaymentDataRepository, PisCommonPaymentDataRepository pisCommonPaymentDataRepository, AspspProfileService aspspProfileService, PisCommonPaymentConfirmationExpirationService pisCommonPaymentConfirmationExpirationService, ScaMethodMapper scaMethodMapper, CmsPsuService cmsPsuService) {
        this.pisCommonPaymentMapper = pisCommonPaymentMapper;
        this.psuDataMapper = psuDataMapper;
        this.pisAuthorisationRepository = pisAuthorisationRepository;
        this.pisPaymentDataRepository = pisPaymentDataRepository;
        this.pisCommonPaymentDataRepository = pisCommonPaymentDataRepository;
        this.aspspProfileService = aspspProfileService;
        this.pisCommonPaymentConfirmationExpirationService = pisCommonPaymentConfirmationExpirationService;
        this.scaMethodMapper = scaMethodMapper;
        this.cmsPsuService = cmsPsuService;
    }
}

