/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.domain.piis;

import de.adorsys.psd2.consent.domain.AccountReferenceEntity;
import de.adorsys.psd2.consent.domain.InstanceDependableEntity;
import de.adorsys.psd2.consent.domain.PsuData;
import de.adorsys.psd2.consent.domain.TppInfoEntity;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.piis.PiisConsentTppAccessType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;

@Entity(name="piis_consent")
@ApiModel(description="Piis consent entity", value="PiisConsentEntity")
public class PiisConsentEntity
extends InstanceDependableEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="piis_consent_generator")
    @SequenceGenerator(name="piis_consent_generator", sequenceName="piis_consent_id_seq")
    private Long id;
    @Column(name="external_id", nullable=false)
    @ApiModelProperty(value="An external exposed identification of the created PIIS consent", required=true, example="bf489af6-a2cb-4b75-b71d-d66d58b934d7")
    private String externalId;
    @Column(name="recurring_indicator", nullable=false)
    @ApiModelProperty(value="'true', if the consent is for recurring access to the account data , 'false', if the consent is for single access to the account data", required=true, example="false")
    private boolean recurringIndicator;
    @Column(name="request_date_time", nullable=false)
    @ApiModelProperty(value="Date of the last request for this consent. The content is the local ASPSP date in ISODate Format", required=true, example="2018-10-25T15:30:35.035Z")
    private OffsetDateTime requestDateTime;
    @Column(name="last_action_date")
    @ApiModelProperty(value="Date of the last action for this consent. The content is the local ASPSP date in ISODate Format", example="2018-05-04")
    private LocalDate lastActionDate;
    @Column(name="expire_date")
    @ApiModelProperty(value="Expiration date for the requested consent. The content is the local ASPSP date in ISODate Format", example="2018-05-04")
    private LocalDate expireDate;
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="psu_id")
    private PsuData psuData;
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="tpp_info_id")
    @ApiModelProperty(value="Information about TPP")
    private TppInfoEntity tppInfo;
    @Column(name="consent_status", nullable=false)
    @Enumerated(value=EnumType.STRING)
    @ApiModelProperty(value="The following code values are permitted 'received', 'valid', 'rejected', 'expired', 'revoked by psu', 'terminated by tpp'. These values might be extended by ASPSP by more values.", required=true, example="VALID")
    private ConsentStatus consentStatus;
    @ManyToMany(cascade={CascadeType.PERSIST})
    @JoinTable(name="piis_consent_acc_reference", joinColumns={@JoinColumn(name="piis_consent_id")}, inverseJoinColumns={@JoinColumn(name="account_reference_id")})
    private List<AccountReferenceEntity> accounts = new ArrayList<AccountReferenceEntity>();
    @Column(name="tpp_access_type", nullable=false)
    @Enumerated(value=EnumType.STRING)
    @ApiModelProperty(value="Type of the tpp access: SINGLE_TPP or ALL_TPP.", required=true, example="ALL_TPP")
    private PiisConsentTppAccessType tppAccessType;
    @Column(name="allowed_frequency_per_day", nullable=false)
    @ApiModelProperty(value="Maximum frequency for an access per day. For a once-off access, this attribute is set to 1", required=true, example="4")
    private int allowedFrequencyPerDay;
    @Column(name="creation_timestamp", nullable=false)
    private OffsetDateTime creationTimestamp = OffsetDateTime.now();

    public Long getId() {
        return this.id;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public boolean isRecurringIndicator() {
        return this.recurringIndicator;
    }

    public OffsetDateTime getRequestDateTime() {
        return this.requestDateTime;
    }

    public LocalDate getLastActionDate() {
        return this.lastActionDate;
    }

    public LocalDate getExpireDate() {
        return this.expireDate;
    }

    public PsuData getPsuData() {
        return this.psuData;
    }

    public TppInfoEntity getTppInfo() {
        return this.tppInfo;
    }

    public ConsentStatus getConsentStatus() {
        return this.consentStatus;
    }

    public List<AccountReferenceEntity> getAccounts() {
        return this.accounts;
    }

    public PiisConsentTppAccessType getTppAccessType() {
        return this.tppAccessType;
    }

    public int getAllowedFrequencyPerDay() {
        return this.allowedFrequencyPerDay;
    }

    public OffsetDateTime getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public void setRecurringIndicator(boolean recurringIndicator) {
        this.recurringIndicator = recurringIndicator;
    }

    public void setRequestDateTime(OffsetDateTime requestDateTime) {
        this.requestDateTime = requestDateTime;
    }

    public void setLastActionDate(LocalDate lastActionDate) {
        this.lastActionDate = lastActionDate;
    }

    public void setExpireDate(LocalDate expireDate) {
        this.expireDate = expireDate;
    }

    public void setPsuData(PsuData psuData) {
        this.psuData = psuData;
    }

    public void setTppInfo(TppInfoEntity tppInfo) {
        this.tppInfo = tppInfo;
    }

    public void setConsentStatus(ConsentStatus consentStatus) {
        this.consentStatus = consentStatus;
    }

    public void setAccounts(List<AccountReferenceEntity> accounts) {
        this.accounts = accounts;
    }

    public void setTppAccessType(PiisConsentTppAccessType tppAccessType) {
        this.tppAccessType = tppAccessType;
    }

    public void setAllowedFrequencyPerDay(int allowedFrequencyPerDay) {
        this.allowedFrequencyPerDay = allowedFrequencyPerDay;
    }

    public void setCreationTimestamp(OffsetDateTime creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PiisConsentEntity)) {
            return false;
        }
        PiisConsentEntity other = (PiisConsentEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$externalId = this.getExternalId();
        String other$externalId = other.getExternalId();
        if (this$externalId == null ? other$externalId != null : !this$externalId.equals(other$externalId)) {
            return false;
        }
        if (this.isRecurringIndicator() != other.isRecurringIndicator()) {
            return false;
        }
        OffsetDateTime this$requestDateTime = this.getRequestDateTime();
        OffsetDateTime other$requestDateTime = other.getRequestDateTime();
        if (this$requestDateTime == null ? other$requestDateTime != null : !((Object)this$requestDateTime).equals(other$requestDateTime)) {
            return false;
        }
        LocalDate this$lastActionDate = this.getLastActionDate();
        LocalDate other$lastActionDate = other.getLastActionDate();
        if (this$lastActionDate == null ? other$lastActionDate != null : !((Object)this$lastActionDate).equals(other$lastActionDate)) {
            return false;
        }
        LocalDate this$expireDate = this.getExpireDate();
        LocalDate other$expireDate = other.getExpireDate();
        if (this$expireDate == null ? other$expireDate != null : !((Object)this$expireDate).equals(other$expireDate)) {
            return false;
        }
        PsuData this$psuData = this.getPsuData();
        PsuData other$psuData = other.getPsuData();
        if (this$psuData == null ? other$psuData != null : !((Object)this$psuData).equals(other$psuData)) {
            return false;
        }
        TppInfoEntity this$tppInfo = this.getTppInfo();
        TppInfoEntity other$tppInfo = other.getTppInfo();
        if (this$tppInfo == null ? other$tppInfo != null : !((Object)this$tppInfo).equals(other$tppInfo)) {
            return false;
        }
        ConsentStatus this$consentStatus = this.getConsentStatus();
        ConsentStatus other$consentStatus = other.getConsentStatus();
        if (this$consentStatus == null ? other$consentStatus != null : !this$consentStatus.equals(other$consentStatus)) {
            return false;
        }
        List<AccountReferenceEntity> this$accounts = this.getAccounts();
        List<AccountReferenceEntity> other$accounts = other.getAccounts();
        if (this$accounts == null ? other$accounts != null : !((Object)this$accounts).equals(other$accounts)) {
            return false;
        }
        PiisConsentTppAccessType this$tppAccessType = this.getTppAccessType();
        PiisConsentTppAccessType other$tppAccessType = other.getTppAccessType();
        if (this$tppAccessType == null ? other$tppAccessType != null : !this$tppAccessType.equals(other$tppAccessType)) {
            return false;
        }
        if (this.getAllowedFrequencyPerDay() != other.getAllowedFrequencyPerDay()) {
            return false;
        }
        OffsetDateTime this$creationTimestamp = this.getCreationTimestamp();
        OffsetDateTime other$creationTimestamp = other.getCreationTimestamp();
        return !(this$creationTimestamp == null ? other$creationTimestamp != null : !((Object)this$creationTimestamp).equals(other$creationTimestamp));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PiisConsentEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : $externalId.hashCode());
        result = result * 59 + (this.isRecurringIndicator() ? 79 : 97);
        OffsetDateTime $requestDateTime = this.getRequestDateTime();
        result = result * 59 + ($requestDateTime == null ? 43 : ((Object)$requestDateTime).hashCode());
        LocalDate $lastActionDate = this.getLastActionDate();
        result = result * 59 + ($lastActionDate == null ? 43 : ((Object)$lastActionDate).hashCode());
        LocalDate $expireDate = this.getExpireDate();
        result = result * 59 + ($expireDate == null ? 43 : ((Object)$expireDate).hashCode());
        PsuData $psuData = this.getPsuData();
        result = result * 59 + ($psuData == null ? 43 : ((Object)$psuData).hashCode());
        TppInfoEntity $tppInfo = this.getTppInfo();
        result = result * 59 + ($tppInfo == null ? 43 : ((Object)$tppInfo).hashCode());
        ConsentStatus $consentStatus = this.getConsentStatus();
        result = result * 59 + ($consentStatus == null ? 43 : $consentStatus.hashCode());
        List<AccountReferenceEntity> $accounts = this.getAccounts();
        result = result * 59 + ($accounts == null ? 43 : ((Object)$accounts).hashCode());
        PiisConsentTppAccessType $tppAccessType = this.getTppAccessType();
        result = result * 59 + ($tppAccessType == null ? 43 : $tppAccessType.hashCode());
        result = result * 59 + this.getAllowedFrequencyPerDay();
        OffsetDateTime $creationTimestamp = this.getCreationTimestamp();
        result = result * 59 + ($creationTimestamp == null ? 43 : ((Object)$creationTimestamp).hashCode());
        return result;
    }

    public String toString() {
        return "PiisConsentEntity(id=" + this.getId() + ", externalId=" + this.getExternalId() + ", recurringIndicator=" + this.isRecurringIndicator() + ", requestDateTime=" + this.getRequestDateTime() + ", lastActionDate=" + this.getLastActionDate() + ", expireDate=" + this.getExpireDate() + ", psuData=" + this.getPsuData() + ", tppInfo=" + this.getTppInfo() + ", consentStatus=" + this.getConsentStatus() + ", accounts=" + this.getAccounts() + ", tppAccessType=" + this.getTppAccessType() + ", allowedFrequencyPerDay=" + this.getAllowedFrequencyPerDay() + ", creationTimestamp=" + this.getCreationTimestamp() + ")";
    }
}

