/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.migration;

import de.adorsys.psd2.consent.domain.account.AisConsent;
import de.adorsys.psd2.consent.domain.consent.ConsentEntity;
import de.adorsys.psd2.consent.repository.ConsentJpaRepository;
import de.adorsys.psd2.consent.repository.migration.ObsoleteAisConsentJpaRepository;
import de.adorsys.psd2.core.data.ais.AisConsentData;
import de.adorsys.psd2.core.mapper.ConsentDataMapper;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AisConsentLazyMigrationService {
    private static final Logger log = LoggerFactory.getLogger(AisConsentLazyMigrationService.class);
    private final ObsoleteAisConsentJpaRepository obsoleteAisConsentJpaRepository;
    private final ConsentJpaRepository consentJpaRepository;
    private final ConsentDataMapper consentDataMapper;

    public ConsentEntity migrateIfNeeded(ConsentEntity consentEntity) {
        Optional<AisConsent> obsoleteAisConsentOptional;
        if (consentEntity.getData() == null && (obsoleteAisConsentOptional = this.obsoleteAisConsentJpaRepository.findByExternalId(consentEntity.getExternalId())).isPresent()) {
            byte[] consentData = this.getConsentData(obsoleteAisConsentOptional.get());
            consentEntity.setData(consentData);
            this.consentJpaRepository.save(consentEntity);
        }
        return consentEntity;
    }

    private byte[] getConsentData(AisConsent aisConsent) {
        AisConsentData aisConsentData = new AisConsentData(aisConsent.getAvailableAccounts(), aisConsent.getAllPsd2(), aisConsent.getAvailableAccountsWithBalance(), aisConsent.isCombinedServiceIndicator());
        return this.consentDataMapper.getBytesFromConsentData((Object)aisConsentData);
    }

    @ConstructorProperties(value={"obsoleteAisConsentJpaRepository", "consentJpaRepository", "consentDataMapper"})
    public AisConsentLazyMigrationService(ObsoleteAisConsentJpaRepository obsoleteAisConsentJpaRepository, ConsentJpaRepository consentJpaRepository, ConsentDataMapper consentDataMapper) {
        this.obsoleteAisConsentJpaRepository = obsoleteAisConsentJpaRepository;
        this.consentJpaRepository = consentJpaRepository;
        this.consentDataMapper = consentDataMapper;
    }
}

