/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.authorisation;

import de.adorsys.psd2.aspsp.profile.service.AspspProfileService;
import de.adorsys.psd2.consent.domain.Authorisable;
import de.adorsys.psd2.consent.domain.consent.ConsentEntity;
import de.adorsys.psd2.consent.repository.ConsentJpaRepository;
import de.adorsys.psd2.consent.service.ConfirmationExpirationService;
import de.adorsys.psd2.consent.service.authorisation.AuthorisationService;
import de.adorsys.psd2.consent.service.authorisation.CmsAuthorisationService;
import de.adorsys.psd2.consent.service.authorisation.PsuService;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationType;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AisAuthService
extends CmsAuthorisationService<ConsentEntity> {
    private static final Logger log = LoggerFactory.getLogger(AisAuthService.class);
    private final ConsentJpaRepository consentJpaRepository;

    @Autowired
    public AisAuthService(PsuService psuService, AspspProfileService aspspProfileService, AuthorisationService authorisationService, ConfirmationExpirationService<ConsentEntity> confirmationExpirationService, ConsentJpaRepository consentJpaRepository) {
        super(psuService, aspspProfileService, authorisationService, confirmationExpirationService);
        this.consentJpaRepository = consentJpaRepository;
    }

    @Override
    public Optional<Authorisable> getNotFinalisedAuthorisationParent(String parentId) {
        return this.consentJpaRepository.findByExternalId(parentId).filter(con -> !con.getConsentStatus().isFinalisedStatus()).map(con -> con);
    }

    @Override
    public Optional<Authorisable> getAuthorisationParent(String parentId) {
        return this.consentJpaRepository.findByExternalId(parentId).map(con -> con);
    }

    @Override
    protected void updateAuthorisable(Object authorisable) {
        this.consentJpaRepository.save((ConsentEntity)authorisable);
    }

    @Override
    AuthorisationType getAuthorisationType() {
        return AuthorisationType.CONSENT;
    }

    @Override
    ConsentEntity castToParent(Authorisable authorisable) {
        return (ConsentEntity)authorisable;
    }
}

