/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.api.ais.UpdateTransactionParametersRequest;
import de.adorsys.psd2.consent.api.service.AccountService;
import de.adorsys.psd2.consent.api.service.AccountServiceEncrypted;
import de.adorsys.psd2.consent.service.security.SecurityDataService;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AccountServiceInternalEncrypted
implements AccountServiceEncrypted {
    private static final Logger log = LoggerFactory.getLogger(AccountServiceInternalEncrypted.class);
    private final SecurityDataService securityDataService;
    private final AccountService accountService;

    public boolean saveTransactionParameters(String encryptedConsentId, String resourceId, UpdateTransactionParametersRequest transactionParameters) {
        Optional<String> optionalId = this.securityDataService.decryptId(encryptedConsentId);
        if (optionalId.isPresent()) {
            return this.accountService.saveTransactionParameters(optionalId.get(), resourceId, transactionParameters);
        }
        log.info("Encrypted Consent ID: [{}]. Save number of transactions failed, couldn't decrypt consent ID", (Object)encryptedConsentId);
        return false;
    }

    @ConstructorProperties(value={"securityDataService", "accountService"})
    public AccountServiceInternalEncrypted(SecurityDataService securityDataService, AccountService accountService) {
        this.securityDataService = securityDataService;
        this.accountService = accountService;
    }
}

