/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.security.provider.aes;

import de.adorsys.psd2.consent.service.security.DecryptedData;
import de.adorsys.psd2.consent.service.security.EncryptedData;
import de.adorsys.psd2.consent.service.security.provider.AbstractCryptoProvider;
import de.adorsys.psd2.consent.service.security.provider.CryptoProvider;
import java.security.GeneralSecurityException;
import java.util.Optional;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AesEcbCryptoProviderImpl
extends AbstractCryptoProvider
implements CryptoProvider {
    private static final Logger log = LoggerFactory.getLogger(AesEcbCryptoProviderImpl.class);
    private final String algorithm;

    public AesEcbCryptoProviderImpl(String cryptoProviderId, String algorithm, int keyLength, int hashIterations, String skfAlgorithm) {
        super(keyLength, hashIterations, skfAlgorithm, cryptoProviderId);
        this.algorithm = algorithm;
    }

    @Override
    public Optional<EncryptedData> encryptData(byte[] data, String password) {
        try {
            SecretKey secretKey = this.getSecretKey(password);
            Cipher cipher = Cipher.getInstance(this.algorithm);
            cipher.init(1, secretKey);
            byte[] encryptedData = cipher.doFinal(data);
            return Optional.of(new EncryptedData(encryptedData));
        }
        catch (GeneralSecurityException e) {
            log.info("Error encryption data: ", (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public Optional<DecryptedData> decryptData(byte[] data, String password) {
        try {
            SecretKey secretKey = this.getSecretKey(password);
            Cipher cipher = Cipher.getInstance(this.algorithm);
            cipher.init(2, secretKey);
            byte[] decryptedData = cipher.doFinal(data);
            return Optional.of(new DecryptedData(decryptedData));
        }
        catch (BadPaddingException e) {
            log.info("Error decryption data. Wrong password");
        }
        catch (GeneralSecurityException e) {
            log.info("Error decryption data: ", (Throwable)e);
        }
        return Optional.empty();
    }
}

