/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.authorisation;

import de.adorsys.psd2.aspsp.profile.service.AspspProfileService;
import de.adorsys.psd2.consent.domain.Authorisable;
import de.adorsys.psd2.consent.domain.payment.PisCommonPaymentData;
import de.adorsys.psd2.consent.domain.payment.PisPaymentData;
import de.adorsys.psd2.consent.service.ConfirmationExpirationService;
import de.adorsys.psd2.consent.service.authorisation.AuthorisationService;
import de.adorsys.psd2.consent.service.authorisation.CommonPaymentService;
import de.adorsys.psd2.consent.service.authorisation.PisAbstractAuthService;
import de.adorsys.psd2.consent.service.authorisation.PsuService;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationType;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PisCancellationAuthService
extends PisAbstractAuthService {
    private static final Logger log = LoggerFactory.getLogger(PisCancellationAuthService.class);
    private final CommonPaymentService commonPaymentService;

    @Autowired
    public PisCancellationAuthService(PsuService psuService, AspspProfileService aspspProfileService, AuthorisationService authorisationService, ConfirmationExpirationService<PisCommonPaymentData> confirmationExpirationService, CommonPaymentService commonPaymentService) {
        super(psuService, aspspProfileService, authorisationService, confirmationExpirationService, commonPaymentService);
        this.commonPaymentService = commonPaymentService;
    }

    @Override
    public Optional<Authorisable> getNotFinalisedAuthorisationParent(String parentId) {
        Optional<PisCommonPaymentData> commonPaymentData = this.commonPaymentService.findByPaymentId(parentId).filter(CollectionUtils::isNotEmpty).map(list -> ((PisPaymentData)list.get(0)).getPaymentData());
        if (commonPaymentData.isEmpty()) {
            commonPaymentData = this.commonPaymentService.findOneByPaymentId(parentId);
        }
        return commonPaymentData.filter(p -> p.getTransactionStatus().isNotFinalisedStatus()).map(this::convertToCommonPayment);
    }

    @Override
    public Optional<Authorisable> getAuthorisationParent(String parentId) {
        return this.commonPaymentService.findOneByPaymentId(parentId).map(con -> con);
    }

    @Override
    AuthorisationType getAuthorisationType() {
        return AuthorisationType.PIS_CANCELLATION;
    }
}

