/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.aspsp;

import de.adorsys.psd2.consent.api.piis.v1.CmsPiisConsent;
import de.adorsys.psd2.consent.aspsp.api.PageData;
import de.adorsys.psd2.consent.aspsp.api.piis.CmsAspspPiisService;
import de.adorsys.psd2.consent.aspsp.api.piis.CreatePiisConsentRequest;
import de.adorsys.psd2.consent.domain.TppInfoEntity;
import de.adorsys.psd2.consent.domain.consent.ConsentEntity;
import de.adorsys.psd2.consent.repository.AspspAccountAccessRepository;
import de.adorsys.psd2.consent.repository.ConsentJpaRepository;
import de.adorsys.psd2.consent.repository.TppInfoRepository;
import de.adorsys.psd2.consent.repository.specification.PiisConsentEntitySpecification;
import de.adorsys.psd2.consent.service.mapper.PiisConsentMapper;
import de.adorsys.psd2.consent.service.migration.PiisConsentLazyMigrationService;
import de.adorsys.psd2.consent.service.psu.util.PageRequestBuilder;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CmsAspspPiisServiceInternal
implements CmsAspspPiisService {
    private static final Logger log = LoggerFactory.getLogger(CmsAspspPiisServiceInternal.class);
    private final ConsentJpaRepository consentJpaRepository;
    private final TppInfoRepository tppInfoRepository;
    private final PiisConsentEntitySpecification piisConsentEntitySpecification;
    private final PiisConsentMapper piisConsentMapper;
    private final PiisConsentLazyMigrationService piisConsentLazyMigrationService;
    private final PageRequestBuilder pageRequestBuilder;
    private final AspspAccountAccessRepository aspspAccountAccessRepository;

    @Transactional
    public Optional<String> createConsent(@NotNull PsuIdData psuIdData, @NotNull CreatePiisConsentRequest request, @NotNull String instanceId) {
        if (this.isInvalidConsentCreationRequest(psuIdData, request)) {
            log.info("Consent cannot be created, because request contains no allowed tppInfo or empty psuIdData or empty accounts or validUntil or cardExpiryDate in the past");
            return Optional.empty();
        }
        this.closePreviousPiisConsents(psuIdData, request, instanceId);
        TppInfoEntity tppInfoEntity = this.getTppInfoEntity(request.getTppAuthorisationNumber());
        ConsentEntity consent = this.piisConsentMapper.mapToPiisConsentEntity(psuIdData, tppInfoEntity, request, instanceId);
        ConsentEntity savedConsent = (ConsentEntity)this.consentJpaRepository.save(consent);
        this.aspspAccountAccessRepository.saveAll(savedConsent.getAspspAccountAccesses());
        if (savedConsent.getId() != null) {
            return Optional.ofNullable(savedConsent.getExternalId());
        }
        log.info("External Consent ID: [{}]. PIIS consent cannot be created, because when saving to DB got null ID", (Object)consent.getExternalId());
        return Optional.empty();
    }

    @Transactional
    @NotNull
    public PageData<List<CmsPiisConsent>> getConsentsForPsu(@NotNull PsuIdData psuIdData, @NotNull String instanceId, Integer pageIndex, Integer itemsPerPage) {
        if (psuIdData.isEmpty()) {
            log.info("InstanceId: [{}]. Export PIIS consents by psu failed, psuIdData is empty or null.", (Object)instanceId);
            return new PageData(Collections.emptyList(), 0L, (long)itemsPerPage.intValue(), 0L);
        }
        return this.mapToPageData((Page<ConsentEntity>)this.consentJpaRepository.findAll(this.piisConsentEntitySpecification.byPsuDataAndInstanceId(psuIdData, instanceId), this.pageRequestBuilder.getPageable(pageIndex, itemsPerPage)));
    }

    @Transactional
    public boolean terminateConsent(@NotNull String consentId, @NotNull String instanceId) {
        Optional entityOptional = this.consentJpaRepository.findOne(this.piisConsentEntitySpecification.byConsentIdAndInstanceId(consentId, instanceId));
        if (entityOptional.isEmpty()) {
            log.info("Consent ID: [{}], Instance ID: [{}]. PIIS consent cannot be terminated, because it was not found by consentId and instanceId", (Object)consentId, (Object)instanceId);
            return false;
        }
        ConsentEntity entity = (ConsentEntity)entityOptional.get();
        this.changeStatusAndLastActionDate(entity, ConsentStatus.TERMINATED_BY_ASPSP);
        this.piisConsentLazyMigrationService.migrateIfNeeded(entity);
        return true;
    }

    private void closePreviousPiisConsents(PsuIdData psuIdData, CreatePiisConsentRequest request, String instanceId) {
        AccountReference accountReference = request.getAccount();
        Specification<ConsentEntity> specification = this.piisConsentEntitySpecification.byPsuIdDataAndAuthorisationNumberAndAccountReferenceAndInstanceId(psuIdData, request.getTppAuthorisationNumber(), accountReference, instanceId);
        List<ConsentEntity> piisConsentEntities = this.consentJpaRepository.findAll(specification);
        piisConsentEntities = this.piisConsentLazyMigrationService.migrateIfNeeded(piisConsentEntities);
        List<ConsentEntity> consentsToRevoke = piisConsentEntities.stream().filter(c -> !c.getConsentStatus().isFinalisedStatus()).collect(Collectors.toList());
        consentsToRevoke.forEach(entity -> this.changeStatusAndLastActionDate((ConsentEntity)entity, ConsentStatus.REVOKED_BY_PSU));
        this.consentJpaRepository.saveAll(consentsToRevoke);
    }

    private void changeStatusAndLastActionDate(ConsentEntity consentEntity, ConsentStatus consentStatus) {
        consentEntity.setLastActionDate(LocalDate.now());
        consentEntity.setConsentStatus(consentStatus);
    }

    private TppInfoEntity getTppInfoEntity(String tppAuthorisationNumber) {
        Optional<TppInfoEntity> tppInfoEntityOptional = this.tppInfoRepository.findByAuthorisationNumber(tppAuthorisationNumber);
        if (tppInfoEntityOptional.isPresent()) {
            return tppInfoEntityOptional.get();
        }
        TppInfoEntity tppInfoEntity = new TppInfoEntity();
        tppInfoEntity.setAuthorisationNumber(tppAuthorisationNumber);
        tppInfoEntity.setAuthorityId("UNKNOWN");
        return (TppInfoEntity)this.tppInfoRepository.save(tppInfoEntity);
    }

    private boolean isInvalidConsentCreationRequest(@NotNull PsuIdData psuIdData, CreatePiisConsentRequest request) {
        return StringUtils.isBlank((CharSequence)request.getTppAuthorisationNumber()) || psuIdData.isEmpty() || request.getAccount() == null || request.getValidUntil() == null || request.getValidUntil().isBefore(LocalDate.now()) || request.getCardExpiryDate() != null && request.getCardExpiryDate().isBefore(LocalDate.now());
    }

    private PageData<List<CmsPiisConsent>> mapToPageData(Page<ConsentEntity> entities) {
        return new PageData(entities.stream().map(this.piisConsentLazyMigrationService::migrateIfNeeded).map(this.piisConsentMapper::mapToCmsPiisConsent).collect(Collectors.toList()), (long)entities.getPageable().getPageNumber(), (long)entities.getPageable().getPageSize(), entities.getTotalElements());
    }

    @ConstructorProperties(value={"consentJpaRepository", "tppInfoRepository", "piisConsentEntitySpecification", "piisConsentMapper", "piisConsentLazyMigrationService", "pageRequestBuilder", "aspspAccountAccessRepository"})
    public CmsAspspPiisServiceInternal(ConsentJpaRepository consentJpaRepository, TppInfoRepository tppInfoRepository, PiisConsentEntitySpecification piisConsentEntitySpecification, PiisConsentMapper piisConsentMapper, PiisConsentLazyMigrationService piisConsentLazyMigrationService, PageRequestBuilder pageRequestBuilder, AspspAccountAccessRepository aspspAccountAccessRepository) {
        this.consentJpaRepository = consentJpaRepository;
        this.tppInfoRepository = tppInfoRepository;
        this.piisConsentEntitySpecification = piisConsentEntitySpecification;
        this.piisConsentMapper = piisConsentMapper;
        this.piisConsentLazyMigrationService = piisConsentLazyMigrationService;
        this.pageRequestBuilder = pageRequestBuilder;
        this.aspspAccountAccessRepository = aspspAccountAccessRepository;
    }
}

