/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.service.TppService;
import de.adorsys.psd2.consent.domain.TppInfoEntity;
import de.adorsys.psd2.consent.repository.TppInfoRepository;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.core.tpp.TppRole;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class TppServiceInternal
implements TppService {
    private static final Logger log = LoggerFactory.getLogger(TppServiceInternal.class);
    private final TppInfoRepository tppInfoRepository;
    @Value(value="${xs2a.cms.service.instance-id:UNDEFINED}")
    private String serviceInstanceId;

    @Transactional
    public CmsResponse<Boolean> updateTppInfo(@NotNull TppInfo tppInfo) {
        Optional<TppInfoEntity> tppInfoEntityOptional = this.tppInfoRepository.findFirstByAuthorisationNumberAndInstanceId(tppInfo.getAuthorisationNumber(), this.serviceInstanceId);
        if (tppInfoEntityOptional.isEmpty()) {
            return CmsResponse.builder().payload((Object)false).build();
        }
        TppInfoEntity tppInfoEntity = tppInfoEntityOptional.get();
        if (this.isRolesChanged(tppInfoEntity.getTppRoles(), tppInfo.getTppRoles())) {
            tppInfoEntity.setTppRoles(tppInfo.getTppRoles());
        }
        return CmsResponse.builder().payload((Object)true).build();
    }

    private boolean isRolesChanged(List<TppRole> savedTppRoles, List<TppRole> tppRoles) {
        return CollectionUtils.isNotEmpty(savedTppRoles) && CollectionUtils.isEmpty(tppRoles) || CollectionUtils.isEmpty(savedTppRoles) && CollectionUtils.isNotEmpty(tppRoles) || CollectionUtils.isNotEmpty(savedTppRoles) && CollectionUtils.isNotEmpty(tppRoles) && !CollectionUtils.isEqualCollection(savedTppRoles, tppRoles);
    }

    @ConstructorProperties(value={"tppInfoRepository"})
    public TppServiceInternal(TppInfoRepository tppInfoRepository) {
        this.tppInfoRepository = tppInfoRepository;
    }
}

