package de.adorsys.psd2.consent.service.mapper;

import de.adorsys.psd2.consent.domain.AuthorisationTemplateEntity;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationTemplate;
import de.adorsys.psd2.xs2a.core.tpp.TppRedirectUri;
import java.util.Optional;
import javax.annotation.processing.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2021-12-06T15:22:06+0000",
    comments = "version: 1.4.1.Final, compiler: javac, environment: Java 11.0.13 (Azul Systems, Inc.)"
)
@Component
public class AuthorisationTemplateMapperImpl implements AuthorisationTemplateMapper {

    @Override
    public AuthorisationTemplate mapToAuthorisationTemplate(AuthorisationTemplateEntity entity) {
        if ( entity == null ) {
            return null;
        }

        AuthorisationTemplate authorisationTemplate = new AuthorisationTemplate();

        authorisationTemplate.setTppRedirectUri( createTppRedirectUri(entity.getRedirectUri(), entity.getNokRedirectUri()) );
        authorisationTemplate.setCancelTppRedirectUri( createTppRedirectUri(entity.getCancelRedirectUri(), entity.getCancelNokRedirectUri()) );

        return authorisationTemplate;
    }

    @Override
    public AuthorisationTemplateEntity mapToAuthorisationTemplateEntity(AuthorisationTemplate authorisationTemplate) {
        if ( authorisationTemplate == null ) {
            return null;
        }

        AuthorisationTemplateEntity authorisationTemplateEntity = new AuthorisationTemplateEntity();

        authorisationTemplateEntity.setRedirectUri( getUriOrNull(authorisationTemplate.getTppRedirectUri(), TppRedirectUri::getUri) );
        authorisationTemplateEntity.setNokRedirectUri( getUriOrNull(authorisationTemplate.getTppRedirectUri(), TppRedirectUri::getNokUri) );
        authorisationTemplateEntity.setCancelRedirectUri( getUriOrNull(authorisationTemplate.getCancelTppRedirectUri(), TppRedirectUri::getUri) );
        authorisationTemplateEntity.setCancelNokRedirectUri( getUriOrNull(authorisationTemplate.getCancelTppRedirectUri(), TppRedirectUri::getNokUri) );

        return authorisationTemplateEntity;
    }
}
