package de.adorsys.psd2.consent.service.mapper;

import de.adorsys.psd2.consent.api.ais.CmsConsent;
import de.adorsys.psd2.core.data.ais.AisConsent;
import de.adorsys.psd2.core.data.ais.AisConsent.AisConsentBuilder;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2021-11-17T09:57:11+0000",
    comments = "version: 1.4.1.Final, compiler: javac, environment: Java 11.0.13 (Azul Systems, Inc.)"
)
@Component
public class CmsAisConsentMapperImpl extends CmsAisConsentMapper {

    @Override
    public AisConsent mapToAisConsent(CmsConsent cmsConsent) {
        if ( cmsConsent == null ) {
            return null;
        }

        AisConsentBuilder<?, ?> aisConsent = AisConsent.builder();

        aisConsent.consentTppInformation( cmsConsent.getTppInformation() );
        aisConsent.id( cmsConsent.getId() );
        aisConsent.internalRequestId( cmsConsent.getInternalRequestId() );
        aisConsent.consentStatus( cmsConsent.getConsentStatus() );
        aisConsent.frequencyPerDay( cmsConsent.getFrequencyPerDay() );
        aisConsent.recurringIndicator( cmsConsent.isRecurringIndicator() );
        aisConsent.multilevelScaRequired( cmsConsent.isMultilevelScaRequired() );
        aisConsent.validUntil( cmsConsent.getValidUntil() );
        aisConsent.expireDate( cmsConsent.getExpireDate() );
        aisConsent.lastActionDate( cmsConsent.getLastActionDate() );
        aisConsent.creationTimestamp( cmsConsent.getCreationTimestamp() );
        aisConsent.statusChangeTimestamp( cmsConsent.getStatusChangeTimestamp() );
        aisConsent.authorisationTemplate( cmsConsent.getAuthorisationTemplate() );
        List<PsuIdData> list = cmsConsent.getPsuIdDataList();
        if ( list != null ) {
            aisConsent.psuIdDataList( new ArrayList<PsuIdData>( list ) );
        }
        Map<String, Integer> map = cmsConsent.getUsages();
        if ( map != null ) {
            aisConsent.usages( new HashMap<String, Integer>( map ) );
        }
        aisConsent.tppAccountAccesses( cmsConsent.getTppAccountAccesses() );
        aisConsent.aspspAccountAccesses( cmsConsent.getAspspAccountAccesses() );
        aisConsent.instanceId( cmsConsent.getInstanceId() );
        aisConsent.consentType( cmsConsent.getConsentType() );
        aisConsent.signingBasketBlocked( cmsConsent.isSigningBasketBlocked() );
        aisConsent.signingBasketAuthorised( cmsConsent.isSigningBasketAuthorised() );

        aisConsent.consentData( consentDataMapper.mapToAisConsentData(cmsConsent.getConsentData()) );
        aisConsent.authorisations( mapToAccountConsentAuthorisation(cmsConsent.getAuthorisations()) );

        return aisConsent.build();
    }
}
