/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.sha;

import de.adorsys.psd2.consent.service.sha.ChecksumCalculatingService;
import de.adorsys.psd2.consent.service.sha.NoProcessingChecksumService;
import de.adorsys.psd2.consent.service.sha.impl.AisChecksumCalculatingServiceV3;
import de.adorsys.psd2.consent.service.sha.impl.AisChecksumCalculatingServiceV4;
import de.adorsys.psd2.consent.service.sha.impl.AisChecksumCalculatingServiceV5;
import de.adorsys.psd2.xs2a.core.consent.ConsentType;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.apache.commons.collections4.keyvalue.MultiKey;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ChecksumCalculatingFactory {
    private static final Logger log = LoggerFactory.getLogger(ChecksumCalculatingFactory.class);
    private final MultiKeyMap<String, ChecksumCalculatingService> services = new MultiKeyMap();
    @Autowired
    private AisChecksumCalculatingServiceV3 aisV3;
    @Autowired
    private AisChecksumCalculatingServiceV4 aisV4;
    @Autowired
    private AisChecksumCalculatingServiceV5 aisV5;
    @Autowired
    private NoProcessingChecksumService noProcessingService;

    @PostConstruct
    public void init() {
        this.services.put(new MultiKey((Object)"001", (Object)ConsentType.AIS.getName()), (Object)this.noProcessingService);
        this.services.put(new MultiKey((Object)"002", (Object)ConsentType.AIS.getName()), (Object)this.noProcessingService);
        this.services.put(new MultiKey((Object)this.aisV3.getVersion(), (Object)ConsentType.AIS.getName()), (Object)this.aisV3);
        this.services.put(new MultiKey((Object)this.aisV4.getVersion(), (Object)ConsentType.AIS.getName()), (Object)this.aisV4);
        this.services.put(new MultiKey((Object)this.aisV5.getVersion(), (Object)ConsentType.AIS.getName()), (Object)this.aisV5);
    }

    public Optional<ChecksumCalculatingService> getServiceByChecksum(byte[] checksum, ConsentType consentType) {
        if (checksum == null) {
            log.debug("Checksum is NULL");
            return this.getDefaultService(consentType);
        }
        String checksumStr = new String(checksum);
        String[] elements = checksumStr.split("_%_");
        String versionSting = elements[0];
        Optional<ChecksumCalculatingService> checksumCalculatingServiceOptional = Optional.ofNullable((ChecksumCalculatingService)this.services.get((Object)new MultiKey((Object)versionSting, (Object)consentType.getName())));
        if (checksumCalculatingServiceOptional.isEmpty()) {
            log.info("Unknown version: [{}] ", (Object)versionSting);
        }
        return checksumCalculatingServiceOptional;
    }

    private Optional<ChecksumCalculatingService> getDefaultService(ConsentType consentType) {
        if (ConsentType.AIS == consentType) {
            return Optional.of(this.aisV5);
        }
        log.info("Given consent type `[{}]` is not supported.", (Object)consentType);
        return Optional.empty();
    }
}

