/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.domain;

import de.adorsys.psd2.consent.domain.InstanceDependableEntity;
import de.adorsys.psd2.consent.domain.PsuData;
import de.adorsys.psd2.consent.domain.ScaMethod;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationType;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;

@Entity(name="authorisation")
public class AuthorisationEntity
extends InstanceDependableEntity {
    @Id
    @Column(name="authorisation_id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="authorisation_generator")
    @SequenceGenerator(name="authorisation_generator", sequenceName="authorisation_id_seq", allocationSize=1)
    private Long id;
    @Column(name="external_id", nullable=false)
    private String externalId;
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="psu_id")
    private PsuData psuData;
    @Column(name="parent_id", nullable=false)
    private String parentExternalId;
    @Column(name="sca_status", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private ScaStatus scaStatus;
    @Column(name="authentication_method_id")
    private String authenticationMethodId;
    @Column(name="sca_authentication_data")
    private String scaAuthenticationData;
    @Column(name="redirect_expiration_timestamp")
    private OffsetDateTime redirectUrlExpirationTimestamp;
    @Column(name="expiration_timestamp")
    private OffsetDateTime authorisationExpirationTimestamp;
    @Column(name="sca_approach", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private ScaApproach scaApproach;
    @Column(name="redirect_uri")
    private String tppOkRedirectUri;
    @Column(name="nok_redirect_uri")
    private String tppNokRedirectUri;
    @ElementCollection
    @CollectionTable(name="auth_available_sca_method", joinColumns={@JoinColumn(name="authorisation_id")})
    private List<ScaMethod> availableScaMethods = new ArrayList<ScaMethod>();
    @Column(name="type", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private AuthorisationType type;

    public boolean isRedirectUrlNotExpired() {
        return this.redirectUrlExpirationTimestamp.isAfter(OffsetDateTime.now());
    }

    public boolean isAuthorisationNotExpired() {
        return this.authorisationExpirationTimestamp.isAfter(OffsetDateTime.now());
    }

    public Long getId() {
        return this.id;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public PsuData getPsuData() {
        return this.psuData;
    }

    public String getParentExternalId() {
        return this.parentExternalId;
    }

    public ScaStatus getScaStatus() {
        return this.scaStatus;
    }

    public String getAuthenticationMethodId() {
        return this.authenticationMethodId;
    }

    public String getScaAuthenticationData() {
        return this.scaAuthenticationData;
    }

    public OffsetDateTime getRedirectUrlExpirationTimestamp() {
        return this.redirectUrlExpirationTimestamp;
    }

    public OffsetDateTime getAuthorisationExpirationTimestamp() {
        return this.authorisationExpirationTimestamp;
    }

    public ScaApproach getScaApproach() {
        return this.scaApproach;
    }

    public String getTppOkRedirectUri() {
        return this.tppOkRedirectUri;
    }

    public String getTppNokRedirectUri() {
        return this.tppNokRedirectUri;
    }

    public List<ScaMethod> getAvailableScaMethods() {
        return this.availableScaMethods;
    }

    public AuthorisationType getType() {
        return this.type;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public void setPsuData(PsuData psuData) {
        this.psuData = psuData;
    }

    public void setParentExternalId(String parentExternalId) {
        this.parentExternalId = parentExternalId;
    }

    public void setScaStatus(ScaStatus scaStatus) {
        this.scaStatus = scaStatus;
    }

    public void setAuthenticationMethodId(String authenticationMethodId) {
        this.authenticationMethodId = authenticationMethodId;
    }

    public void setScaAuthenticationData(String scaAuthenticationData) {
        this.scaAuthenticationData = scaAuthenticationData;
    }

    public void setRedirectUrlExpirationTimestamp(OffsetDateTime redirectUrlExpirationTimestamp) {
        this.redirectUrlExpirationTimestamp = redirectUrlExpirationTimestamp;
    }

    public void setAuthorisationExpirationTimestamp(OffsetDateTime authorisationExpirationTimestamp) {
        this.authorisationExpirationTimestamp = authorisationExpirationTimestamp;
    }

    public void setScaApproach(ScaApproach scaApproach) {
        this.scaApproach = scaApproach;
    }

    public void setTppOkRedirectUri(String tppOkRedirectUri) {
        this.tppOkRedirectUri = tppOkRedirectUri;
    }

    public void setTppNokRedirectUri(String tppNokRedirectUri) {
        this.tppNokRedirectUri = tppNokRedirectUri;
    }

    public void setAvailableScaMethods(List<ScaMethod> availableScaMethods) {
        this.availableScaMethods = availableScaMethods;
    }

    public void setType(AuthorisationType type) {
        this.type = type;
    }

    public String toString() {
        return "AuthorisationEntity(id=" + this.getId() + ", externalId=" + this.getExternalId() + ", psuData=" + this.getPsuData() + ", parentExternalId=" + this.getParentExternalId() + ", scaStatus=" + this.getScaStatus() + ", authenticationMethodId=" + this.getAuthenticationMethodId() + ", scaAuthenticationData=" + this.getScaAuthenticationData() + ", redirectUrlExpirationTimestamp=" + this.getRedirectUrlExpirationTimestamp() + ", authorisationExpirationTimestamp=" + this.getAuthorisationExpirationTimestamp() + ", scaApproach=" + this.getScaApproach() + ", tppOkRedirectUri=" + this.getTppOkRedirectUri() + ", tppNokRedirectUri=" + this.getTppNokRedirectUri() + ", availableScaMethods=" + this.getAvailableScaMethods() + ", type=" + this.getType() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthorisationEntity)) {
            return false;
        }
        AuthorisationEntity other = (AuthorisationEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$externalId = this.getExternalId();
        String other$externalId = other.getExternalId();
        if (this$externalId == null ? other$externalId != null : !this$externalId.equals(other$externalId)) {
            return false;
        }
        PsuData this$psuData = this.getPsuData();
        PsuData other$psuData = other.getPsuData();
        if (this$psuData == null ? other$psuData != null : !((Object)this$psuData).equals(other$psuData)) {
            return false;
        }
        String this$parentExternalId = this.getParentExternalId();
        String other$parentExternalId = other.getParentExternalId();
        if (this$parentExternalId == null ? other$parentExternalId != null : !this$parentExternalId.equals(other$parentExternalId)) {
            return false;
        }
        ScaStatus this$scaStatus = this.getScaStatus();
        ScaStatus other$scaStatus = other.getScaStatus();
        if (this$scaStatus == null ? other$scaStatus != null : !this$scaStatus.equals(other$scaStatus)) {
            return false;
        }
        String this$authenticationMethodId = this.getAuthenticationMethodId();
        String other$authenticationMethodId = other.getAuthenticationMethodId();
        if (this$authenticationMethodId == null ? other$authenticationMethodId != null : !this$authenticationMethodId.equals(other$authenticationMethodId)) {
            return false;
        }
        String this$scaAuthenticationData = this.getScaAuthenticationData();
        String other$scaAuthenticationData = other.getScaAuthenticationData();
        if (this$scaAuthenticationData == null ? other$scaAuthenticationData != null : !this$scaAuthenticationData.equals(other$scaAuthenticationData)) {
            return false;
        }
        OffsetDateTime this$redirectUrlExpirationTimestamp = this.getRedirectUrlExpirationTimestamp();
        OffsetDateTime other$redirectUrlExpirationTimestamp = other.getRedirectUrlExpirationTimestamp();
        if (this$redirectUrlExpirationTimestamp == null ? other$redirectUrlExpirationTimestamp != null : !((Object)this$redirectUrlExpirationTimestamp).equals(other$redirectUrlExpirationTimestamp)) {
            return false;
        }
        OffsetDateTime this$authorisationExpirationTimestamp = this.getAuthorisationExpirationTimestamp();
        OffsetDateTime other$authorisationExpirationTimestamp = other.getAuthorisationExpirationTimestamp();
        if (this$authorisationExpirationTimestamp == null ? other$authorisationExpirationTimestamp != null : !((Object)this$authorisationExpirationTimestamp).equals(other$authorisationExpirationTimestamp)) {
            return false;
        }
        ScaApproach this$scaApproach = this.getScaApproach();
        ScaApproach other$scaApproach = other.getScaApproach();
        if (this$scaApproach == null ? other$scaApproach != null : !this$scaApproach.equals(other$scaApproach)) {
            return false;
        }
        String this$tppOkRedirectUri = this.getTppOkRedirectUri();
        String other$tppOkRedirectUri = other.getTppOkRedirectUri();
        if (this$tppOkRedirectUri == null ? other$tppOkRedirectUri != null : !this$tppOkRedirectUri.equals(other$tppOkRedirectUri)) {
            return false;
        }
        String this$tppNokRedirectUri = this.getTppNokRedirectUri();
        String other$tppNokRedirectUri = other.getTppNokRedirectUri();
        if (this$tppNokRedirectUri == null ? other$tppNokRedirectUri != null : !this$tppNokRedirectUri.equals(other$tppNokRedirectUri)) {
            return false;
        }
        List<ScaMethod> this$availableScaMethods = this.getAvailableScaMethods();
        List<ScaMethod> other$availableScaMethods = other.getAvailableScaMethods();
        if (this$availableScaMethods == null ? other$availableScaMethods != null : !((Object)this$availableScaMethods).equals(other$availableScaMethods)) {
            return false;
        }
        AuthorisationType this$type = this.getType();
        AuthorisationType other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AuthorisationEntity;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : $externalId.hashCode());
        PsuData $psuData = this.getPsuData();
        result = result * 59 + ($psuData == null ? 43 : ((Object)$psuData).hashCode());
        String $parentExternalId = this.getParentExternalId();
        result = result * 59 + ($parentExternalId == null ? 43 : $parentExternalId.hashCode());
        ScaStatus $scaStatus = this.getScaStatus();
        result = result * 59 + ($scaStatus == null ? 43 : $scaStatus.hashCode());
        String $authenticationMethodId = this.getAuthenticationMethodId();
        result = result * 59 + ($authenticationMethodId == null ? 43 : $authenticationMethodId.hashCode());
        String $scaAuthenticationData = this.getScaAuthenticationData();
        result = result * 59 + ($scaAuthenticationData == null ? 43 : $scaAuthenticationData.hashCode());
        OffsetDateTime $redirectUrlExpirationTimestamp = this.getRedirectUrlExpirationTimestamp();
        result = result * 59 + ($redirectUrlExpirationTimestamp == null ? 43 : ((Object)$redirectUrlExpirationTimestamp).hashCode());
        OffsetDateTime $authorisationExpirationTimestamp = this.getAuthorisationExpirationTimestamp();
        result = result * 59 + ($authorisationExpirationTimestamp == null ? 43 : ((Object)$authorisationExpirationTimestamp).hashCode());
        ScaApproach $scaApproach = this.getScaApproach();
        result = result * 59 + ($scaApproach == null ? 43 : $scaApproach.hashCode());
        String $tppOkRedirectUri = this.getTppOkRedirectUri();
        result = result * 59 + ($tppOkRedirectUri == null ? 43 : $tppOkRedirectUri.hashCode());
        String $tppNokRedirectUri = this.getTppNokRedirectUri();
        result = result * 59 + ($tppNokRedirectUri == null ? 43 : $tppNokRedirectUri.hashCode());
        List<ScaMethod> $availableScaMethods = this.getAvailableScaMethods();
        result = result * 59 + ($availableScaMethods == null ? 43 : ((Object)$availableScaMethods).hashCode());
        AuthorisationType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }
}

