/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.security;

public final class DecryptedIdSet {
    private static final String PREVIOUS_DATA_PROVIDER_ID = "gQ8wkMeo93";
    private final String decryptedId;
    private final String randomSecretKey;
    private final String dataEncryptionProviderId;

    public DecryptedIdSet(String ... idDataValues) {
        if (idDataValues.length < 2) {
            throw new IllegalArgumentException("At least decrypted ID and secret key must be present");
        }
        this.decryptedId = idDataValues[0];
        this.randomSecretKey = idDataValues[1];
        this.dataEncryptionProviderId = idDataValues.length > 2 ? idDataValues[2] : PREVIOUS_DATA_PROVIDER_ID;
    }

    public String getDecryptedId() {
        return this.decryptedId;
    }

    public String getRandomSecretKey() {
        return this.randomSecretKey;
    }

    public String getDataEncryptionProviderId() {
        return this.dataEncryptionProviderId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DecryptedIdSet)) {
            return false;
        }
        DecryptedIdSet other = (DecryptedIdSet)o;
        String this$decryptedId = this.getDecryptedId();
        String other$decryptedId = other.getDecryptedId();
        if (this$decryptedId == null ? other$decryptedId != null : !this$decryptedId.equals(other$decryptedId)) {
            return false;
        }
        String this$randomSecretKey = this.getRandomSecretKey();
        String other$randomSecretKey = other.getRandomSecretKey();
        if (this$randomSecretKey == null ? other$randomSecretKey != null : !this$randomSecretKey.equals(other$randomSecretKey)) {
            return false;
        }
        String this$dataEncryptionProviderId = this.getDataEncryptionProviderId();
        String other$dataEncryptionProviderId = other.getDataEncryptionProviderId();
        return !(this$dataEncryptionProviderId == null ? other$dataEncryptionProviderId != null : !this$dataEncryptionProviderId.equals(other$dataEncryptionProviderId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $decryptedId = this.getDecryptedId();
        result = result * 59 + ($decryptedId == null ? 43 : $decryptedId.hashCode());
        String $randomSecretKey = this.getRandomSecretKey();
        result = result * 59 + ($randomSecretKey == null ? 43 : $randomSecretKey.hashCode());
        String $dataEncryptionProviderId = this.getDataEncryptionProviderId();
        result = result * 59 + ($dataEncryptionProviderId == null ? 43 : $dataEncryptionProviderId.hashCode());
        return result;
    }

    public String toString() {
        return "DecryptedIdSet(decryptedId=" + this.getDecryptedId() + ", randomSecretKey=" + this.getRandomSecretKey() + ", dataEncryptionProviderId=" + this.getDataEncryptionProviderId() + ")";
    }
}

