/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.mapper;

import de.adorsys.psd2.consent.api.piis.v2.CmsConfirmationOfFundsAuthorisation;
import de.adorsys.psd2.consent.api.piis.v2.CmsConfirmationOfFundsConsent;
import de.adorsys.psd2.consent.domain.AuthorisationEntity;
import de.adorsys.psd2.consent.domain.account.TppAccountAccess;
import de.adorsys.psd2.consent.domain.consent.ConsentEntity;
import de.adorsys.psd2.consent.domain.consent.ConsentTppInformationEntity;
import de.adorsys.psd2.consent.service.mapper.AuthorisationTemplateMapper;
import de.adorsys.psd2.consent.service.mapper.PsuDataMapper;
import de.adorsys.psd2.consent.service.mapper.TppInfoMapper;
import de.adorsys.psd2.core.data.piis.PiisConsentData;
import de.adorsys.psd2.core.mapper.ConsentDataMapper;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class CmsConfirmationOfFundsMapper {
    private final PsuDataMapper psuDataMapper;
    private final TppInfoMapper tppInfoMapper;
    private final AuthorisationTemplateMapper authorisationTemplateMapper;
    private final ConsentDataMapper consentDataMapper;

    public CmsConfirmationOfFundsConsent mapToCmsConfirmationOfFundsConsent(ConsentEntity consent, List<AuthorisationEntity> authorisations) {
        ConsentTppInformationEntity tppInformation = consent.getTppInformation();
        PiisConsentData piisConsentData = this.consentDataMapper.mapToPiisConsentData(consent.getData());
        return new CmsConfirmationOfFundsConsent(consent.getExternalId(), this.getAccountReference(consent), consent.getValidUntil(), consent.getExpireDate(), consent.getLastActionDate(), consent.getConsentStatus(), tppInformation.isTppRedirectPreferred(), this.psuDataMapper.mapToPsuIdDataList(consent.getPsuDataList()), this.tppInfoMapper.mapToTppInfo(tppInformation.getTppInfo()), this.authorisationTemplateMapper.mapToAuthorisationTemplate(consent.getAuthorisationTemplate()), consent.isMultilevelScaRequired(), consent.getCreationTimestamp(), consent.getStatusChangeTimestamp(), this.mapToAuthorisations(authorisations), piisConsentData.getCardNumber(), piisConsentData.getCardExpiryDate(), piisConsentData.getCardInformation(), piisConsentData.getRegistrationInformation());
    }

    private AccountReference getAccountReference(ConsentEntity consent) {
        if (consent != null && CollectionUtils.isNotEmpty(consent.getTppAccountAccesses())) {
            TppAccountAccess tppAccountAccess = consent.getTppAccountAccesses().get(0);
            return new AccountReference(tppAccountAccess.getAccountReferenceType(), tppAccountAccess.getAccountIdentifier(), tppAccountAccess.getCurrency());
        }
        return null;
    }

    private List<CmsConfirmationOfFundsAuthorisation> mapToAuthorisations(List<AuthorisationEntity> consentAuthorisations) {
        if (CollectionUtils.isEmpty(consentAuthorisations)) {
            return Collections.emptyList();
        }
        return consentAuthorisations.stream().map(auth -> new CmsConfirmationOfFundsAuthorisation(auth.getExternalId(), this.psuDataMapper.mapToPsuIdData(auth.getPsuData()), auth.getScaStatus())).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"psuDataMapper", "tppInfoMapper", "authorisationTemplateMapper", "consentDataMapper"})
    public CmsConfirmationOfFundsMapper(PsuDataMapper psuDataMapper, TppInfoMapper tppInfoMapper, AuthorisationTemplateMapper authorisationTemplateMapper, ConsentDataMapper consentDataMapper) {
        this.psuDataMapper = psuDataMapper;
        this.tppInfoMapper = tppInfoMapper;
        this.authorisationTemplateMapper = authorisationTemplateMapper;
        this.consentDataMapper = consentDataMapper;
    }
}

