/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.mapper;

import de.adorsys.psd2.consent.domain.AuthorisationEntity;
import de.adorsys.psd2.consent.service.mapper.AuthorisationMapper;
import de.adorsys.psd2.consent.service.mapper.PsuDataMapper;
import de.adorsys.psd2.xs2a.core.authorisation.Authorisation;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AuthorisationMapperImpl
implements AuthorisationMapper {
    @Autowired
    private PsuDataMapper psuDataMapper;

    @Override
    public Authorisation mapToAuthorisation(AuthorisationEntity authorisationEntity) {
        if (authorisationEntity == null) {
            return null;
        }
        Authorisation authorisation = new Authorisation();
        authorisation.setPsuIdData(this.psuDataMapper.mapToPsuIdData(authorisationEntity.getPsuData()));
        authorisation.setAuthorisationId(authorisationEntity.getExternalId());
        authorisation.setParentId(authorisationEntity.getParentExternalId());
        authorisation.setChosenScaApproach(authorisationEntity.getScaApproach());
        authorisation.setAuthorisationType(authorisationEntity.getType());
        authorisation.setScaStatus(authorisationEntity.getScaStatus());
        authorisation.setAuthenticationMethodId(authorisationEntity.getAuthenticationMethodId());
        authorisation.setScaAuthenticationData(authorisationEntity.getScaAuthenticationData());
        return authorisation;
    }

    @Override
    public List<Authorisation> mapToAuthorisations(List<AuthorisationEntity> authorisationEntityList) {
        if (authorisationEntityList == null) {
            return null;
        }
        ArrayList<Authorisation> list = new ArrayList<Authorisation>(authorisationEntityList.size());
        for (AuthorisationEntity authorisationEntity : authorisationEntityList) {
            list.add(this.mapToAuthorisation(authorisationEntity));
        }
        return list;
    }
}

