/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.authorisation;

import de.adorsys.psd2.aspsp.profile.service.AspspProfileService;
import de.adorsys.psd2.consent.api.pis.PisPayment;
import de.adorsys.psd2.consent.domain.Authorisable;
import de.adorsys.psd2.consent.domain.payment.PisCommonPaymentData;
import de.adorsys.psd2.consent.service.ConfirmationExpirationService;
import de.adorsys.psd2.consent.service.authorisation.AuthorisationService;
import de.adorsys.psd2.consent.service.authorisation.CmsAuthorisationService;
import de.adorsys.psd2.consent.service.authorisation.CommonPaymentService;
import de.adorsys.psd2.consent.service.authorisation.PsuService;
import java.util.List;
import java.util.stream.Collectors;

public abstract class PisAbstractAuthService
extends CmsAuthorisationService<PisCommonPaymentData> {
    private final CommonPaymentService commonPaymentService;

    protected PisAbstractAuthService(PsuService psuService, AspspProfileService aspspProfileService, AuthorisationService authorisationService, ConfirmationExpirationService<PisCommonPaymentData> confirmationExpirationService, CommonPaymentService commonPaymentService) {
        super(psuService, aspspProfileService, authorisationService, confirmationExpirationService);
        this.commonPaymentService = commonPaymentService;
    }

    @Override
    protected PisCommonPaymentData castToParent(Authorisable authorisable) {
        return (PisCommonPaymentData)authorisable;
    }

    protected PisCommonPaymentData convertToCommonPayment(PisCommonPaymentData pisCommonPaymentData) {
        if (pisCommonPaymentData == null || pisCommonPaymentData.getPayment() != null) {
            return pisCommonPaymentData;
        }
        List<PisPayment> pisPayments = pisCommonPaymentData.getPayments().stream().map(this.commonPaymentService::mapToPisPayment).collect(Collectors.toList());
        byte[] paymentData = this.commonPaymentService.buildPaymentData(pisPayments, pisCommonPaymentData.getPaymentType());
        if (paymentData != null) {
            pisCommonPaymentData.setPayment(paymentData);
            return this.commonPaymentService.save(pisCommonPaymentData);
        }
        return pisCommonPaymentData;
    }
}

