/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.authorisation;

import de.adorsys.psd2.consent.domain.AuthorisationEntity;
import de.adorsys.psd2.consent.domain.PsuData;
import de.adorsys.psd2.consent.repository.AuthorisationRepository;
import de.adorsys.psd2.consent.service.authorisation.AuthServiceResolver;
import de.adorsys.psd2.consent.service.mapper.PsuDataMapper;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationType;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import java.beans.ConstructorProperties;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AuthorisationClosingService {
    private static final Logger log = LoggerFactory.getLogger(AuthorisationClosingService.class);
    private final PsuDataMapper psuDataMapper;
    private final AuthServiceResolver authServiceResolver;
    private final AuthorisationRepository authorisationRepository;

    @Transactional
    public void closePreviousAuthorisationsByAuthorisation(AuthorisationEntity authorisation, PsuIdData psuIdData) {
        if (psuIdData == null || psuIdData.isEmpty()) {
            log.info("Closing previous authorisations by PSU is skipped, because no PSU data has been provided in the request");
            return;
        }
        String parentId = authorisation.getParentExternalId();
        List<AuthorisationEntity> parentAuthorisations = this.authServiceResolver.getAuthService(authorisation.getType()).getAuthorisationsByParentId(parentId);
        List<AuthorisationEntity> previousAuthorisations = parentAuthorisations.stream().filter(a -> !a.getExternalId().equals(authorisation.getExternalId())).collect(Collectors.toList());
        this.closePreviousAuthorisationsByPsu(authorisation.getType(), previousAuthorisations, psuIdData);
    }

    @Transactional
    public void closePreviousAuthorisationsByParent(String parentId, AuthorisationType authorisationType, PsuIdData psuIdData) {
        if (psuIdData == null || psuIdData.isEmpty()) {
            log.info("Closing previous authorisations by PSU is skipped, because no PSU data has been provided in the request");
            return;
        }
        List<AuthorisationEntity> parentAuthorisations = this.authServiceResolver.getAuthService(authorisationType).getAuthorisationsByParentId(parentId);
        this.closePreviousAuthorisationsByPsu(authorisationType, parentAuthorisations, psuIdData);
    }

    private void closePreviousAuthorisationsByPsu(AuthorisationType authorisationType, List<AuthorisationEntity> authorisations, PsuIdData psuIdData) {
        String instanceId = authorisations.isEmpty() ? null : authorisations.get(0).getInstanceId();
        PsuData psuData = this.psuDataMapper.mapToPsuData(psuIdData, instanceId);
        List<AuthorisationEntity> authorisationsToBeClosed = authorisations.stream().filter(auth -> auth.getType().equals((Object)authorisationType)).filter(auth -> Objects.nonNull(auth.getPsuData()) && auth.getPsuData().contentEquals(psuData)).collect(Collectors.toList());
        authorisationsToBeClosed.forEach(this::failAndExpireAuthorisation);
    }

    private void failAndExpireAuthorisation(AuthorisationEntity auth) {
        auth.setScaStatus(ScaStatus.FAILED);
        auth.setRedirectUrlExpirationTimestamp(OffsetDateTime.now());
        this.authorisationRepository.save(auth);
    }

    @ConstructorProperties(value={"psuDataMapper", "authServiceResolver", "authorisationRepository"})
    public AuthorisationClosingService(PsuDataMapper psuDataMapper, AuthServiceResolver authServiceResolver, AuthorisationRepository authorisationRepository) {
        this.psuDataMapper = psuDataMapper;
        this.authServiceResolver = authServiceResolver;
        this.authorisationRepository = authorisationRepository;
    }
}

