/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.aspsp;

import de.adorsys.psd2.consent.api.piis.v1.CmsPiisConsent;
import de.adorsys.psd2.consent.aspsp.api.PageData;
import de.adorsys.psd2.consent.aspsp.api.piis.CmsAspspPiisFundsExportService;
import de.adorsys.psd2.consent.domain.consent.ConsentEntity;
import de.adorsys.psd2.consent.repository.ConsentJpaRepository;
import de.adorsys.psd2.consent.repository.specification.PiisConsentEntitySpecification;
import de.adorsys.psd2.consent.service.mapper.PiisConsentMapper;
import de.adorsys.psd2.consent.service.migration.PiisConsentLazyMigrationService;
import de.adorsys.psd2.consent.service.psu.util.PageRequestBuilder;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CmsAspspPiisFundsExportServiceInternal
implements CmsAspspPiisFundsExportService {
    private static final Logger log = LoggerFactory.getLogger(CmsAspspPiisFundsExportServiceInternal.class);
    private static final String DEFAULT_SERVICE_INSTANCE_ID = "UNDEFINED";
    private final ConsentJpaRepository consentJpaRepository;
    private final PiisConsentEntitySpecification piisConsentEntitySpecification;
    private final PiisConsentMapper piisConsentMapper;
    private final PiisConsentLazyMigrationService piisConsentLazyMigrationService;
    private final PageRequestBuilder pageRequestBuilder;

    @Transactional
    public PageData<Collection<CmsPiisConsent>> exportConsentsByTpp(String tppAuthorisationNumber, @Nullable LocalDate createDateFrom, @Nullable LocalDate createDateTo, @Nullable PsuIdData psuIdData, @Nullable String instanceId, Integer pageIndex, Integer itemsPerPage) {
        if (StringUtils.isBlank((CharSequence)tppAuthorisationNumber)) {
            log.info("TPP ID: [{}], instanceId: [{}]. Export consents by TPP failed, TPP ID is empty or null.", (Object)tppAuthorisationNumber, (Object)instanceId);
            return new PageData(Collections.emptyList(), 0L, (long)itemsPerPage.intValue(), 0L);
        }
        String actualInstanceId = (String)StringUtils.defaultIfEmpty((CharSequence)instanceId, (CharSequence)DEFAULT_SERVICE_INSTANCE_ID);
        return this.mapToPageData((Page<ConsentEntity>)this.consentJpaRepository.findAll(this.piisConsentEntitySpecification.byTppIdAndCreationPeriodAndPsuIdDataAndInstanceId(tppAuthorisationNumber, createDateFrom, createDateTo, psuIdData, actualInstanceId, null), this.pageRequestBuilder.getPageable(pageIndex, itemsPerPage)));
    }

    @Transactional
    public PageData<Collection<CmsPiisConsent>> exportConsentsByPsu(PsuIdData psuIdData, @Nullable LocalDate createDateFrom, @Nullable LocalDate createDateTo, @Nullable String instanceId, Integer pageIndex, Integer itemsPerPage) {
        if (psuIdData == null || psuIdData.isEmpty()) {
            log.info("InstanceId: [{}]. Export consents by psu failed, psuIdData is empty or null.", (Object)instanceId);
            return new PageData(Collections.emptyList(), 0L, (long)itemsPerPage.intValue(), 0L);
        }
        String actualInstanceId = (String)StringUtils.defaultIfEmpty((CharSequence)instanceId, (CharSequence)DEFAULT_SERVICE_INSTANCE_ID);
        return this.mapToPageData((Page<ConsentEntity>)this.consentJpaRepository.findAll(this.piisConsentEntitySpecification.byPsuIdDataAndCreationPeriodAndInstanceIdAndAdditionalTppInfo(psuIdData, createDateFrom, createDateTo, actualInstanceId, null), this.pageRequestBuilder.getPageable(pageIndex, itemsPerPage)));
    }

    @Transactional
    public PageData<Collection<CmsPiisConsent>> exportConsentsByAccountId(@NotNull String aspspAccountId, @Nullable LocalDate createDateFrom, @Nullable LocalDate createDateTo, @Nullable String instanceId, Integer pageIndex, Integer itemsPerPage) {
        if (StringUtils.isBlank((CharSequence)aspspAccountId)) {
            log.info("InstanceId: [{}]. Export consents by accountId failed, aspspAccountId is empty or null.", (Object)instanceId);
            return new PageData(Collections.emptyList(), 0L, (long)itemsPerPage.intValue(), 0L);
        }
        String actualInstanceId = (String)StringUtils.defaultIfEmpty((CharSequence)instanceId, (CharSequence)DEFAULT_SERVICE_INSTANCE_ID);
        return this.mapToPageData((Page<ConsentEntity>)this.consentJpaRepository.findAll(this.piisConsentEntitySpecification.byAspspAccountIdAndCreationPeriodAndInstanceIdAndAdditionalTppInfo(aspspAccountId, createDateFrom, createDateTo, actualInstanceId, null), this.pageRequestBuilder.getPageable(pageIndex, itemsPerPage)));
    }

    private PageData<Collection<CmsPiisConsent>> mapToPageData(Page<ConsentEntity> entities) {
        return new PageData((Object)entities.stream().map(this.piisConsentLazyMigrationService::migrateIfNeeded).map(this.piisConsentMapper::mapToCmsPiisConsent).collect(Collectors.toList()), (long)entities.getPageable().getPageNumber(), (long)entities.getPageable().getPageSize(), entities.getTotalElements());
    }

    @ConstructorProperties(value={"consentJpaRepository", "piisConsentEntitySpecification", "piisConsentMapper", "piisConsentLazyMigrationService", "pageRequestBuilder"})
    public CmsAspspPiisFundsExportServiceInternal(ConsentJpaRepository consentJpaRepository, PiisConsentEntitySpecification piisConsentEntitySpecification, PiisConsentMapper piisConsentMapper, PiisConsentLazyMigrationService piisConsentLazyMigrationService, PageRequestBuilder pageRequestBuilder) {
        this.consentJpaRepository = consentJpaRepository;
        this.piisConsentEntitySpecification = piisConsentEntitySpecification;
        this.piisConsentMapper = piisConsentMapper;
        this.piisConsentLazyMigrationService = piisConsentLazyMigrationService;
        this.pageRequestBuilder = pageRequestBuilder;
    }
}

