/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.ais.CmsConsent;
import de.adorsys.psd2.consent.api.service.PiisConsentService;
import de.adorsys.psd2.consent.domain.consent.ConsentEntity;
import de.adorsys.psd2.consent.repository.ConsentJpaRepository;
import de.adorsys.psd2.consent.repository.specification.PiisConsentEntitySpecification;
import de.adorsys.psd2.consent.service.mapper.CmsConsentMapper;
import de.adorsys.psd2.consent.service.migration.PiisConsentLazyMigrationService;
import de.adorsys.psd2.xs2a.core.profile.AccountReferenceSelector;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class PiisConsentServiceInternal
implements PiisConsentService {
    private static final Logger log = LoggerFactory.getLogger(PiisConsentServiceInternal.class);
    private final ConsentJpaRepository consentJpaRepository;
    private final CmsConsentMapper cmsConsentMapper;
    private final PiisConsentEntitySpecification piisConsentEntitySpecification;
    private final PiisConsentLazyMigrationService piisConsentLazyMigrationService;

    @Transactional
    public CmsResponse<List<CmsConsent>> getPiisConsentListByAccountIdentifier(@Nullable Currency currency, AccountReferenceSelector accountReferenceSelector) {
        Specification<ConsentEntity> specification = currency == null ? this.piisConsentEntitySpecification.byAccountReferenceSelector(accountReferenceSelector) : this.piisConsentEntitySpecification.byCurrencyAndAccountReferenceSelector(currency, accountReferenceSelector);
        List consents = this.consentJpaRepository.findAll(specification).stream().map(this.piisConsentLazyMigrationService::migrateIfNeeded).map(consentEntity -> this.cmsConsentMapper.mapToCmsConsent((ConsentEntity)consentEntity, Collections.emptyList(), Collections.emptyMap())).collect(Collectors.toList());
        return CmsResponse.builder().payload(consents).build();
    }

    @ConstructorProperties(value={"consentJpaRepository", "cmsConsentMapper", "piisConsentEntitySpecification", "piisConsentLazyMigrationService"})
    public PiisConsentServiceInternal(ConsentJpaRepository consentJpaRepository, CmsConsentMapper cmsConsentMapper, PiisConsentEntitySpecification piisConsentEntitySpecification, PiisConsentLazyMigrationService piisConsentLazyMigrationService) {
        this.consentJpaRepository = consentJpaRepository;
        this.cmsConsentMapper = cmsConsentMapper;
        this.piisConsentEntitySpecification = piisConsentEntitySpecification;
        this.piisConsentLazyMigrationService = piisConsentLazyMigrationService;
    }
}

