/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.mapper;

import de.adorsys.psd2.consent.api.TypeAccess;
import de.adorsys.psd2.consent.api.ais.AdditionalAccountInformationType;
import de.adorsys.psd2.consent.domain.account.AspspAccountAccess;
import de.adorsys.psd2.consent.domain.account.TppAccountAccess;
import de.adorsys.psd2.consent.domain.consent.ConsentEntity;
import de.adorsys.psd2.core.data.AccountAccess;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.core.profile.AdditionalInformationAccess;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class AccessMapper {
    public AccountAccess mapTppAccessesToAccountAccess(List<TppAccountAccess> tppAccountAccesses, AdditionalAccountInformationType ownerNameType, AdditionalAccountInformationType trustedBeneficiariesType) {
        AccountAccessListHolder holder = new AccountAccessListHolder();
        tppAccountAccesses.forEach(a -> {
            AccountReference accountReference = new AccountReference(a.getAccountReferenceType(), a.getAccountIdentifier(), a.getCurrency());
            holder.addAccountReference(accountReference, a.getTypeAccess());
        });
        return this.buildAccountAccess(holder, ownerNameType, trustedBeneficiariesType);
    }

    public AccountAccess mapAspspAccessesToAccountAccess(List<AspspAccountAccess> aspspAccountAccesses, AdditionalAccountInformationType ownerNameType, AdditionalAccountInformationType trustedBeneficiariesType) {
        AccountAccessListHolder holder = new AccountAccessListHolder();
        aspspAccountAccesses.forEach(a -> {
            AccountReference accountReference = new AccountReference(a.getId(), a.getAccountReferenceType(), a.getAccountIdentifier(), a.getCurrency(), a.getResourceId(), a.getAspspAccountId());
            holder.addAccountReference(accountReference, a.getTypeAccess());
        });
        return this.buildAccountAccess(holder, ownerNameType, trustedBeneficiariesType);
    }

    public List<TppAccountAccess> mapToTppAccountAccess(ConsentEntity consent, AccountAccess accountAccess) {
        ArrayList<TppAccountAccess> tppAccountAccesses = new ArrayList<TppAccountAccess>();
        tppAccountAccesses.addAll(accountAccess.getAccounts().stream().map(a -> new TppAccountAccess(a.getId(), consent, a.getUsedAccountReferenceSelector().getAccountValue(), TypeAccess.ACCOUNT, a.getUsedAccountReferenceSelector().getAccountReferenceType(), a.getCurrency())).collect(Collectors.toList()));
        tppAccountAccesses.addAll(accountAccess.getBalances().stream().map(a -> new TppAccountAccess(a.getId(), consent, a.getUsedAccountReferenceSelector().getAccountValue(), TypeAccess.BALANCE, a.getUsedAccountReferenceSelector().getAccountReferenceType(), a.getCurrency())).collect(Collectors.toList()));
        tppAccountAccesses.addAll(accountAccess.getTransactions().stream().map(a -> new TppAccountAccess(a.getId(), consent, a.getUsedAccountReferenceSelector().getAccountValue(), TypeAccess.TRANSACTION, a.getUsedAccountReferenceSelector().getAccountReferenceType(), a.getCurrency())).collect(Collectors.toList()));
        AdditionalInformationAccess additionalInformationAccess = accountAccess.getAdditionalInformationAccess();
        if (additionalInformationAccess != null) {
            if (CollectionUtils.isNotEmpty((Collection)additionalInformationAccess.getOwnerName())) {
                tppAccountAccesses.addAll(additionalInformationAccess.getOwnerName().stream().map(a -> new TppAccountAccess(a.getId(), consent, a.getUsedAccountReferenceSelector().getAccountValue(), TypeAccess.OWNER_NAME, a.getUsedAccountReferenceSelector().getAccountReferenceType(), a.getCurrency())).collect(Collectors.toList()));
            }
            if (CollectionUtils.isNotEmpty((Collection)additionalInformationAccess.getTrustedBeneficiaries())) {
                tppAccountAccesses.addAll(additionalInformationAccess.getTrustedBeneficiaries().stream().map(a -> new TppAccountAccess(a.getId(), consent, a.getUsedAccountReferenceSelector().getAccountValue(), TypeAccess.BENEFICIARIES, a.getUsedAccountReferenceSelector().getAccountReferenceType(), a.getCurrency())).collect(Collectors.toList()));
            }
        }
        return tppAccountAccesses;
    }

    public List<AspspAccountAccess> mapToAspspAccountAccess(ConsentEntity consent, AccountAccess accountAccess) {
        ArrayList<AspspAccountAccess> aspspAccountAccesses = new ArrayList<AspspAccountAccess>();
        aspspAccountAccesses.addAll(accountAccess.getAccounts().stream().map(a -> new AspspAccountAccess(a.getId(), consent, a.getUsedAccountReferenceSelector().getAccountValue(), TypeAccess.ACCOUNT, a.getUsedAccountReferenceSelector().getAccountReferenceType(), a.getCurrency(), a.getResourceId(), a.getAspspAccountId())).collect(Collectors.toList()));
        aspspAccountAccesses.addAll(accountAccess.getBalances().stream().map(a -> new AspspAccountAccess(a.getId(), consent, a.getUsedAccountReferenceSelector().getAccountValue(), TypeAccess.BALANCE, a.getUsedAccountReferenceSelector().getAccountReferenceType(), a.getCurrency(), a.getResourceId(), a.getAspspAccountId())).collect(Collectors.toList()));
        aspspAccountAccesses.addAll(accountAccess.getTransactions().stream().map(a -> new AspspAccountAccess(a.getId(), consent, a.getUsedAccountReferenceSelector().getAccountValue(), TypeAccess.TRANSACTION, a.getUsedAccountReferenceSelector().getAccountReferenceType(), a.getCurrency(), a.getResourceId(), a.getAspspAccountId())).collect(Collectors.toList()));
        AdditionalInformationAccess additionalInformationAccess = accountAccess.getAdditionalInformationAccess();
        if (additionalInformationAccess != null) {
            if (CollectionUtils.isNotEmpty((Collection)additionalInformationAccess.getOwnerName())) {
                aspspAccountAccesses.addAll(additionalInformationAccess.getOwnerName().stream().map(a -> new AspspAccountAccess(a.getId(), consent, a.getUsedAccountReferenceSelector().getAccountValue(), TypeAccess.OWNER_NAME, a.getUsedAccountReferenceSelector().getAccountReferenceType(), a.getCurrency(), a.getResourceId(), a.getAspspAccountId())).collect(Collectors.toList()));
            }
            if (CollectionUtils.isNotEmpty((Collection)additionalInformationAccess.getTrustedBeneficiaries())) {
                aspspAccountAccesses.addAll(additionalInformationAccess.getTrustedBeneficiaries().stream().map(a -> new AspspAccountAccess(a.getId(), consent, a.getUsedAccountReferenceSelector().getAccountValue(), TypeAccess.BENEFICIARIES, a.getUsedAccountReferenceSelector().getAccountReferenceType(), a.getCurrency(), a.getResourceId(), a.getAspspAccountId())).collect(Collectors.toList()));
            }
        }
        return aspspAccountAccesses;
    }

    public AspspAccountAccess mapToAspspAccountAccess(ConsentEntity consent, AccountReference accountReference) {
        return new AspspAccountAccess(consent, accountReference.getUsedAccountReferenceSelector().getAccountValue(), TypeAccess.ACCOUNT, accountReference.getUsedAccountReferenceSelector().getAccountReferenceType(), accountReference.getCurrency(), accountReference.getResourceId(), accountReference.getAspspAccountId());
    }

    public AccountReference mapToAccountReference(AspspAccountAccess aspspAccountAccess) {
        return new AccountReference(aspspAccountAccess.getAccountReferenceType(), aspspAccountAccess.getAccountIdentifier(), aspspAccountAccess.getCurrency(), aspspAccountAccess.getResourceId(), aspspAccountAccess.getAspspAccountId());
    }

    private AccountAccess buildAccountAccess(AccountAccessListHolder holder, AdditionalAccountInformationType ownerNameType, AdditionalAccountInformationType trustedBeneficiariesType) {
        return new AccountAccess(holder.getAccounts(), holder.getBalances(), holder.getTransactions(), new AdditionalInformationAccess(this.resolveAdditionalAccountInformationType(ownerNameType).getReferencesByType(holder.getOwnerNames()), this.resolveAdditionalAccountInformationType(trustedBeneficiariesType).getReferencesByType(holder.getTrustedBeneficiaries())));
    }

    private AdditionalAccountInformationType resolveAdditionalAccountInformationType(AdditionalAccountInformationType additionalAccountInformationType) {
        return additionalAccountInformationType == null ? AdditionalAccountInformationType.NONE : additionalAccountInformationType;
    }

    private static class AccountAccessListHolder {
        List<AccountReference> accounts = new ArrayList<AccountReference>();
        List<AccountReference> balances = new ArrayList<AccountReference>();
        List<AccountReference> transactions = new ArrayList<AccountReference>();
        List<AccountReference> ownerNames = new ArrayList<AccountReference>();
        List<AccountReference> trustedBeneficiaries = new ArrayList<AccountReference>();

        private AccountAccessListHolder() {
        }

        void addAccountReference(AccountReference accountReference, TypeAccess typeAccess) {
            if (TypeAccess.ACCOUNT == typeAccess) {
                this.accounts.add(accountReference);
            } else if (TypeAccess.BALANCE == typeAccess) {
                this.balances.add(accountReference);
            } else if (TypeAccess.TRANSACTION == typeAccess) {
                this.transactions.add(accountReference);
            } else if (TypeAccess.OWNER_NAME == typeAccess) {
                this.ownerNames.add(accountReference);
            } else if (TypeAccess.BENEFICIARIES == typeAccess) {
                this.trustedBeneficiaries.add(accountReference);
            }
        }

        public List<AccountReference> getAccounts() {
            return this.accounts;
        }

        public List<AccountReference> getBalances() {
            return this.balances;
        }

        public List<AccountReference> getTransactions() {
            return this.transactions;
        }

        public List<AccountReference> getOwnerNames() {
            return this.ownerNames;
        }

        public List<AccountReference> getTrustedBeneficiaries() {
            return this.trustedBeneficiaries;
        }
    }
}

