/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.authorisation;

import de.adorsys.psd2.consent.api.pis.PisPayment;
import de.adorsys.psd2.consent.domain.payment.PisCommonPaymentData;
import de.adorsys.psd2.consent.domain.payment.PisPaymentData;
import de.adorsys.psd2.consent.repository.PisCommonPaymentDataRepository;
import de.adorsys.psd2.consent.repository.PisPaymentDataRepository;
import de.adorsys.psd2.consent.service.CorePaymentsConvertService;
import de.adorsys.psd2.consent.service.PisCommonPaymentConfirmationExpirationService;
import de.adorsys.psd2.consent.service.mapper.PisCommonPaymentMapper;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class CommonPaymentService {
    private final PisCommonPaymentMapper pisCommonPaymentMapper;
    private final PisCommonPaymentDataRepository pisCommonPaymentDataRepository;
    private final CorePaymentsConvertService corePaymentsConvertService;
    private final PisPaymentDataRepository pisPaymentDataRepository;
    private final PisCommonPaymentConfirmationExpirationService pisCommonPaymentConfirmationExpirationService;

    public PisCommonPaymentData save(PisCommonPaymentData pisCommonPaymentData) {
        return (PisCommonPaymentData)this.pisCommonPaymentDataRepository.save(pisCommonPaymentData);
    }

    public PisPayment mapToPisPayment(PisPaymentData pisPaymentData) {
        return this.pisCommonPaymentMapper.mapToPisPayment(pisPaymentData);
    }

    public byte[] buildPaymentData(List<PisPayment> pisPayments, PaymentType paymentType) {
        return this.corePaymentsConvertService.buildPaymentData(pisPayments, paymentType);
    }

    public Optional<List<PisPaymentData>> findByPaymentIdAndPaymentDataTransactionStatusIn(String parentId, List<TransactionStatus> transactionStatuses) {
        return this.pisPaymentDataRepository.findByPaymentIdAndPaymentDataTransactionStatusIn(parentId, transactionStatuses);
    }

    public PisCommonPaymentData checkAndUpdateOnConfirmationExpiration(PisCommonPaymentData pisCommonPaymentData) {
        return this.pisCommonPaymentConfirmationExpirationService.checkAndUpdateOnConfirmationExpiration(pisCommonPaymentData);
    }

    public Optional<PisCommonPaymentData> findByPaymentIdAndTransactionStatusIn(String parentId, List<TransactionStatus> transactionStatuses) {
        return this.pisCommonPaymentDataRepository.findByPaymentIdAndTransactionStatusIn(parentId, transactionStatuses);
    }

    public Optional<PisCommonPaymentData> findOneByPaymentId(String parentId) {
        return this.pisCommonPaymentDataRepository.findByPaymentId(parentId);
    }

    public Optional<List<PisPaymentData>> findByPaymentId(String parentId) {
        return this.pisPaymentDataRepository.findByPaymentId(parentId);
    }

    @ConstructorProperties(value={"pisCommonPaymentMapper", "pisCommonPaymentDataRepository", "corePaymentsConvertService", "pisPaymentDataRepository", "pisCommonPaymentConfirmationExpirationService"})
    public CommonPaymentService(PisCommonPaymentMapper pisCommonPaymentMapper, PisCommonPaymentDataRepository pisCommonPaymentDataRepository, CorePaymentsConvertService corePaymentsConvertService, PisPaymentDataRepository pisPaymentDataRepository, PisCommonPaymentConfirmationExpirationService pisCommonPaymentConfirmationExpirationService) {
        this.pisCommonPaymentMapper = pisCommonPaymentMapper;
        this.pisCommonPaymentDataRepository = pisCommonPaymentDataRepository;
        this.corePaymentsConvertService = corePaymentsConvertService;
        this.pisPaymentDataRepository = pisPaymentDataRepository;
        this.pisCommonPaymentConfirmationExpirationService = pisCommonPaymentConfirmationExpirationService;
    }
}

