/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.repository.specification;

import de.adorsys.psd2.consent.domain.consent.ConsentEntity;
import de.adorsys.psd2.consent.repository.specification.CommonSpecification;
import de.adorsys.psd2.consent.repository.specification.ConsentSpecification;
import de.adorsys.psd2.consent.repository.specification.EntityAttributeSpecificationProvider;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.consent.ConsentType;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Predicate;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.jpa.domain.Specification;

public abstract class ConsentFilterableSpecification {
    private final CommonSpecification<ConsentEntity> commonSpecification;
    private final ConsentSpecification consentSpecification;

    public abstract List<ConsentType> getTypes();

    public Specification<ConsentEntity> byConsentIdAndInstanceId(String consentId, String instanceId) {
        return this.consentSpecification.byConsentIdAndInstanceId(consentId, instanceId).and(this.byConsentType());
    }

    public Specification<ConsentEntity> byTppIdAndCreationPeriodAndPsuIdDataAndInstanceId(@NotNull String tppAuthorisationNumber, @Nullable LocalDate createDateFrom, @Nullable LocalDate createDateTo, @Nullable PsuIdData psuIdData, @Nullable String instanceId, @Nullable String additionalTppInfo) {
        return (Specification & Serializable)(root, query, cb) -> {
            root.joinList("aspspAccountAccesses");
            return Optional.ofNullable(this.consentSpecification.byTppIdAndCreationPeriodAndPsuIdDataAndInstanceId(tppAuthorisationNumber, createDateFrom, createDateTo, psuIdData, instanceId)).map(s -> s.and(this.byConsentType())).map(s -> s.and(this.byAdditionalTppInfo(additionalTppInfo))).map(s -> s.toPredicate(root, query, cb)).orElse(null);
        };
    }

    public Specification<ConsentEntity> byPsuDataInListAndInstanceIdAndAdditionalTppInfo(PsuIdData psuIdData, String instanceId, String additionalTppInfo, List<ConsentStatus> statuses, List<String> accountNumbers) {
        return Optional.ofNullable(this.consentSpecification.byPsuDataInListAndInstanceId(psuIdData, instanceId)).map(s -> s.and(this.byAdditionalTppInfo(additionalTppInfo))).map(s -> s.and(this.byInConsentStatuses(statuses))).map(s -> s.and(this.byInAccountNumbers(accountNumbers))).map(s -> s.and(this.byConsentType())).orElse(null);
    }

    private Specification<ConsentEntity> byInConsentStatuses(List<ConsentStatus> statuses) {
        return (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
            if (CollectionUtils.isEmpty((Collection)statuses)) {
                return null;
            }
            return criteriaBuilder.and(new Predicate[]{root.get("consentStatus").in((Collection)statuses)});
        };
    }

    private Specification<ConsentEntity> byInAccountNumbers(List<String> accountNumbers) {
        return (Specification & Serializable)(root, query, cb) -> {
            if (CollectionUtils.isEmpty((Collection)accountNumbers)) {
                return null;
            }
            Join aspspAccountAccessesJoin = root.join("aspspAccountAccesses");
            return Specification.where(EntityAttributeSpecificationProvider.provideSpecificationForJoinedEntityAttributeIn(aspspAccountAccessesJoin, "accountIdentifier", accountNumbers)).toPredicate(root, query, cb);
        };
    }

    public Specification<ConsentEntity> byAdditionalTppInfo(@Nullable String additionalTppInfo) {
        return (Specification & Serializable)(root, query, cb) -> {
            Join consentTppInformationJoin = root.join("tppInformation");
            return EntityAttributeSpecificationProvider.provideSpecificationForJoinedEntityAttribute(consentTppInformationJoin, "additionalInfo", additionalTppInfo).toPredicate(root, query, cb);
        };
    }

    public Specification<ConsentEntity> byPsuDataInListAndInstanceId(PsuIdData psuIdData, String instanceId) {
        return this.consentSpecification.byPsuDataInListAndInstanceId(psuIdData, instanceId).and(this.byConsentType());
    }

    public Specification<ConsentEntity> byPsuIdDataAndCreationPeriodAndInstanceIdAndAdditionalTppInfo(@NotNull PsuIdData psuIdData, @Nullable LocalDate createDateFrom, @Nullable LocalDate createDateTo, @Nullable String instanceId, @Nullable String additionalTppInfo) {
        return (Specification & Serializable)(root, query, cb) -> {
            root.joinList("aspspAccountAccesses");
            return Optional.ofNullable(this.commonSpecification.byPsuIdDataAndCreationPeriodAndInstanceId(psuIdData, createDateFrom, createDateTo, instanceId)).map(s -> s.and(this.byConsentType())).map(s -> s.and(this.byAdditionalTppInfo(additionalTppInfo))).map(s -> s.toPredicate(root, query, cb)).orElse(null);
        };
    }

    public Specification<ConsentEntity> byAspspAccountIdAndCreationPeriodAndInstanceIdAndAdditionalTppInfo(@NotNull String aspspAccountId, @Nullable LocalDate createDateFrom, @Nullable LocalDate createDateTo, @Nullable String instanceId, @Nullable String additionalTppInfo) {
        return Optional.ofNullable(this.consentSpecification.byAspspAccountIdAndCreationPeriodAndInstanceId(aspspAccountId, createDateFrom, createDateTo, instanceId)).map(s -> s.and(this.byConsentType())).map(s -> s.and(this.byAdditionalTppInfo(additionalTppInfo))).orElse(null);
    }

    public Specification<ConsentEntity> byConsentType() {
        return EntityAttributeSpecificationProvider.provideSpecificationForEntityAttributeInList("consentType", this.getTypes().stream().map(Enum::name).collect(Collectors.toList()));
    }

    @ConstructorProperties(value={"commonSpecification", "consentSpecification"})
    public ConsentFilterableSpecification(CommonSpecification<ConsentEntity> commonSpecification, ConsentSpecification consentSpecification) {
        this.commonSpecification = commonSpecification;
        this.consentSpecification = consentSpecification;
    }
}

