/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.domain.account;

import de.adorsys.psd2.consent.api.TypeAccess;
import de.adorsys.psd2.consent.domain.consent.ConsentEntity;
import de.adorsys.psd2.xs2a.core.profile.AccountReferenceType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Currency;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;

@Entity(name="aspsp_account_access")
@ApiModel(description="Aspsp Account access", value="AspspAccountAccess")
public class AspspAccountAccess {
    @Id
    @Column(name="id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="aspsp_account_access_generator")
    @SequenceGenerator(name="aspsp_account_access_generator", sequenceName="aspsp_account_access_seq", allocationSize=1)
    private Long id;
    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="consent_id", nullable=false)
    private ConsentEntity consent;
    @Column(name="resource_id", length=100)
    @ApiModelProperty(value="RESOURCE-ID: This identification is denoting the addressed account.")
    private String resourceId;
    @Column(name="aspsp_account_id", length=100)
    @ApiModelProperty(value="Aspsp-Account-ID: Bank specific account ID", example="26bb59a3-2f63-4027-ad38-67d87e59611a")
    private String aspspAccountId;
    @Column(name="account_identifier", length=34, nullable=false)
    @ApiModelProperty(value="Account-Identifier: This data element can be used in the body of the CreateConsentReq Request Message for retrieving account access consent from this payment account", example="DE2310010010123456789", required=true)
    private String accountIdentifier;
    @Column(name="currency", length=3)
    @ApiModelProperty(value="Currency Type", example="EUR")
    private Currency currency;
    @Column(name="type_access", length=30, nullable=false)
    @Enumerated(value=EnumType.STRING)
    @ApiModelProperty(value="Types of given accesses: account, balance, transaction, payment", example="ACCOUNT")
    private TypeAccess typeAccess;
    @Column(name="account_reference_type", nullable=true, length=30)
    @Enumerated(value=EnumType.STRING)
    @ApiModelProperty(value="Type of the account: IBAN, BBAN, IBAN, BBAN, PAN, MASKED_PAN, MSISDN", required=true, example="IBAN")
    private AccountReferenceType accountReferenceType;

    public AspspAccountAccess(ConsentEntity consent, String accountIdentifier, TypeAccess typeAccess, AccountReferenceType accountReferenceType, Currency currency, String resourceId, String aspspAccountId) {
        this.consent = consent;
        this.resourceId = resourceId;
        this.aspspAccountId = aspspAccountId;
        this.accountIdentifier = accountIdentifier;
        this.typeAccess = typeAccess;
        this.accountReferenceType = accountReferenceType;
        this.currency = currency;
    }

    public AspspAccountAccess(Long id, ConsentEntity consent, String accountIdentifier, TypeAccess typeAccess, AccountReferenceType accountReferenceType, Currency currency, String resourceId, String aspspAccountId) {
        this.id = id;
        this.consent = consent;
        this.resourceId = resourceId;
        this.aspspAccountId = aspspAccountId;
        this.accountIdentifier = accountIdentifier;
        this.typeAccess = typeAccess;
        this.accountReferenceType = accountReferenceType;
        this.currency = currency;
    }

    public String toString() {
        return "AspspAccountAccess{id=" + this.id + ", consentId=" + this.consent.getId() + ", resourceId='" + this.resourceId + "', aspspAccountId='" + this.aspspAccountId + "', accountIdentifier='" + this.accountIdentifier + "', currency=" + this.currency + ", typeAccess=" + this.typeAccess + ", accountReferenceType=" + this.accountReferenceType + "}";
    }

    public Long getId() {
        return this.id;
    }

    public ConsentEntity getConsent() {
        return this.consent;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getAspspAccountId() {
        return this.aspspAccountId;
    }

    public String getAccountIdentifier() {
        return this.accountIdentifier;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public TypeAccess getTypeAccess() {
        return this.typeAccess;
    }

    public AccountReferenceType getAccountReferenceType() {
        return this.accountReferenceType;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setConsent(ConsentEntity consent) {
        this.consent = consent;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public void setAspspAccountId(String aspspAccountId) {
        this.aspspAccountId = aspspAccountId;
    }

    public void setAccountIdentifier(String accountIdentifier) {
        this.accountIdentifier = accountIdentifier;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public void setTypeAccess(TypeAccess typeAccess) {
        this.typeAccess = typeAccess;
    }

    public void setAccountReferenceType(AccountReferenceType accountReferenceType) {
        this.accountReferenceType = accountReferenceType;
    }

    public AspspAccountAccess() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AspspAccountAccess)) {
            return false;
        }
        AspspAccountAccess other = (AspspAccountAccess)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$resourceId = this.getResourceId();
        String other$resourceId = other.getResourceId();
        if (this$resourceId == null ? other$resourceId != null : !this$resourceId.equals(other$resourceId)) {
            return false;
        }
        String this$aspspAccountId = this.getAspspAccountId();
        String other$aspspAccountId = other.getAspspAccountId();
        if (this$aspspAccountId == null ? other$aspspAccountId != null : !this$aspspAccountId.equals(other$aspspAccountId)) {
            return false;
        }
        String this$accountIdentifier = this.getAccountIdentifier();
        String other$accountIdentifier = other.getAccountIdentifier();
        if (this$accountIdentifier == null ? other$accountIdentifier != null : !this$accountIdentifier.equals(other$accountIdentifier)) {
            return false;
        }
        Currency this$currency = this.getCurrency();
        Currency other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        TypeAccess this$typeAccess = this.getTypeAccess();
        TypeAccess other$typeAccess = other.getTypeAccess();
        if (this$typeAccess == null ? other$typeAccess != null : !this$typeAccess.equals(other$typeAccess)) {
            return false;
        }
        AccountReferenceType this$accountReferenceType = this.getAccountReferenceType();
        AccountReferenceType other$accountReferenceType = other.getAccountReferenceType();
        return !(this$accountReferenceType == null ? other$accountReferenceType != null : !this$accountReferenceType.equals(other$accountReferenceType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AspspAccountAccess;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $resourceId = this.getResourceId();
        result = result * 59 + ($resourceId == null ? 43 : $resourceId.hashCode());
        String $aspspAccountId = this.getAspspAccountId();
        result = result * 59 + ($aspspAccountId == null ? 43 : $aspspAccountId.hashCode());
        String $accountIdentifier = this.getAccountIdentifier();
        result = result * 59 + ($accountIdentifier == null ? 43 : $accountIdentifier.hashCode());
        Currency $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        TypeAccess $typeAccess = this.getTypeAccess();
        result = result * 59 + ($typeAccess == null ? 43 : $typeAccess.hashCode());
        AccountReferenceType $accountReferenceType = this.getAccountReferenceType();
        result = result * 59 + ($accountReferenceType == null ? 43 : $accountReferenceType.hashCode());
        return result;
    }
}

