/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.authorisation;

import de.adorsys.psd2.aspsp.profile.domain.common.CommonAspspProfileSetting;
import de.adorsys.psd2.aspsp.profile.service.AspspProfileService;
import de.adorsys.psd2.consent.api.authorisation.CreateAuthorisationRequest;
import de.adorsys.psd2.consent.api.authorisation.UpdateAuthorisationRequest;
import de.adorsys.psd2.consent.domain.Authorisable;
import de.adorsys.psd2.consent.domain.AuthorisationEntity;
import de.adorsys.psd2.consent.domain.PsuData;
import de.adorsys.psd2.consent.service.ConfirmationExpirationService;
import de.adorsys.psd2.consent.service.authorisation.AuthService;
import de.adorsys.psd2.consent.service.authorisation.AuthorisationService;
import de.adorsys.psd2.consent.service.authorisation.PsuService;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationType;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CmsAuthorisationService<T extends Authorisable>
implements AuthService {
    private static final Logger log = LoggerFactory.getLogger(CmsAuthorisationService.class);
    protected final PsuService psuService;
    protected final AspspProfileService aspspProfileService;
    protected final AuthorisationService authorisationService;
    protected final ConfirmationExpirationService<T> confirmationExpirationService;

    @Override
    public List<AuthorisationEntity> getAuthorisationsByParentId(String parentId) {
        return this.authorisationService.findAllByParentExternalIdAndType(parentId, this.getAuthorisationType());
    }

    @Override
    public Optional<AuthorisationEntity> getAuthorisationById(String authorisationId) {
        return this.authorisationService.findByExternalIdAndType(authorisationId, this.getAuthorisationType());
    }

    @Override
    public AuthorisationEntity saveAuthorisation(CreateAuthorisationRequest request, Authorisable authorisationParent) {
        List<PsuData> psuDataList = authorisationParent.getPsuDataList();
        Optional<PsuData> psuDataOptional = this.psuService.definePsuDataForAuthorisation(this.psuService.mapToPsuData(request.getPsuData(), authorisationParent.getInstanceId()), psuDataList);
        psuDataOptional.ifPresent(psuData -> authorisationParent.setPsuDataList(this.psuService.enrichPsuData((PsuData)psuData, psuDataList)));
        authorisationParent.setPsuDataList(psuDataList);
        this.resolveScaStatus(request, psuDataOptional);
        CommonAspspProfileSetting commonAspspProfileSetting = this.aspspProfileService.getAspspSettings(authorisationParent.getInstanceId()).getCommon();
        AuthorisationEntity entity = this.authorisationService.prepareAuthorisationEntity(authorisationParent, request, psuDataOptional, this.getAuthorisationType(), commonAspspProfileSetting.getRedirectUrlExpirationTimeMs(), commonAspspProfileSetting.getAuthorisationExpirationTimeMs());
        return this.authorisationService.save(entity);
    }

    private void resolveScaStatus(CreateAuthorisationRequest request, Optional<PsuData> psuDataOptional) {
        ScaStatus scaStatus = request.getScaStatus();
        if (psuDataOptional.isPresent() && ScaStatus.STARTED.equals((Object)scaStatus)) {
            scaStatus = ScaStatus.PSUIDENTIFIED;
        }
        if (psuDataOptional.isEmpty() && ScaStatus.STARTED.equals((Object)scaStatus)) {
            scaStatus = ScaStatus.RECEIVED;
        }
        request.setScaStatus(scaStatus);
    }

    @Override
    public AuthorisationEntity doUpdateAuthorisation(AuthorisationEntity authorisationEntity, UpdateAuthorisationRequest updateAuthorisationRequest) {
        PsuData psuRequest = this.psuService.mapToPsuData(updateAuthorisationRequest.getPsuData(), authorisationEntity.getInstanceId());
        if (ScaStatus.RECEIVED == authorisationEntity.getScaStatus()) {
            if (!this.psuService.isPsuDataRequestCorrect(psuRequest, authorisationEntity.getPsuData())) {
                log.info("Authorisation ID: [{}], SCA status: [{}]. Update authorisation failed, because psu data request does not match stored psu data", (Object)authorisationEntity.getExternalId(), (Object)authorisationEntity.getScaStatus().getValue());
                return authorisationEntity;
            }
            Optional<Authorisable> aisConsentOptional = this.getAuthorisationParent(authorisationEntity.getParentExternalId());
            if (aisConsentOptional.isEmpty()) {
                log.info("Authorisation ID: [{}], Parent ID: [{}]. Update authorisation failed, couldn't find parent by ID from the authorisation", (Object)authorisationEntity.getExternalId(), (Object)authorisationEntity.getParentExternalId());
                return authorisationEntity;
            }
            Authorisable authorisationParent = aisConsentOptional.get();
            Optional<PsuData> psuDataOptional = this.psuService.definePsuDataForAuthorisation(psuRequest, authorisationParent.getPsuDataList());
            if (psuDataOptional.isPresent()) {
                PsuData psuData = psuDataOptional.get();
                authorisationParent.setPsuDataList(this.psuService.enrichPsuData(psuData, authorisationParent.getPsuDataList()));
                authorisationEntity.setPsuData(psuData);
                this.updateAuthorisable(authorisationParent);
            }
        } else {
            boolean isPsuCorrect;
            boolean bl = isPsuCorrect = Objects.nonNull(authorisationEntity.getPsuData()) && this.isPsuDataCorrectIfPresent(psuRequest, authorisationEntity);
            if (!isPsuCorrect) {
                log.info("Authorisation ID: [{}], SCA status: [{}]. Update authorisation failed, because PSU data request does not match stored PSU data", (Object)authorisationEntity.getExternalId(), (Object)authorisationEntity.getScaStatus().getValue());
                return authorisationEntity;
            }
        }
        if (ScaStatus.SCAMETHODSELECTED == updateAuthorisationRequest.getScaStatus()) {
            authorisationEntity.setAuthenticationMethodId(updateAuthorisationRequest.getAuthenticationMethodId());
        }
        authorisationEntity.setScaStatus(updateAuthorisationRequest.getScaStatus());
        return this.authorisationService.save(authorisationEntity);
    }

    private boolean isPsuDataCorrectIfPresent(PsuData psuRequest, AuthorisationEntity authorisationEntity) {
        if (psuRequest != null) {
            return authorisationEntity.getPsuData().contentEquals(psuRequest);
        }
        return true;
    }

    @Override
    public Authorisable checkAndUpdateOnConfirmationExpiration(Authorisable authorisable) {
        return this.confirmationExpirationService.checkAndUpdateOnConfirmationExpiration(this.castToParent(authorisable));
    }

    @Override
    public boolean isConfirmationExpired(Authorisable authorisable) {
        return this.confirmationExpirationService.isConfirmationExpired(this.castToParent(authorisable));
    }

    @Override
    public Authorisable updateOnConfirmationExpiration(Authorisable authorisable) {
        return this.confirmationExpirationService.updateOnConfirmationExpiration(this.castToParent(authorisable));
    }

    protected void updateAuthorisable(Object authorisable) {
    }

    abstract AuthorisationType getAuthorisationType();

    abstract T castToParent(Authorisable var1);

    @ConstructorProperties(value={"psuService", "aspspProfileService", "authorisationService", "confirmationExpirationService"})
    public CmsAuthorisationService(PsuService psuService, AspspProfileService aspspProfileService, AuthorisationService authorisationService, ConfirmationExpirationService<T> confirmationExpirationService) {
        this.psuService = psuService;
        this.aspspProfileService = aspspProfileService;
        this.authorisationService = authorisationService;
        this.confirmationExpirationService = confirmationExpirationService;
    }
}

