/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.authorisation;

import de.adorsys.psd2.consent.api.authorisation.CreateAuthorisationRequest;
import de.adorsys.psd2.consent.domain.Authorisable;
import de.adorsys.psd2.consent.domain.AuthorisationEntity;
import de.adorsys.psd2.consent.domain.PsuData;
import de.adorsys.psd2.consent.repository.AuthorisationRepository;
import de.adorsys.psd2.consent.service.mapper.AuthorisationMapper;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationType;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class AuthorisationService {
    protected final AuthorisationMapper authorisationMapper;
    protected final AuthorisationRepository authorisationRepository;

    public List<AuthorisationEntity> findAllByParentExternalIdAndType(String parentId, AuthorisationType authorisationType) {
        return this.authorisationRepository.findAllByParentExternalIdAndType(parentId, authorisationType);
    }

    public Optional<AuthorisationEntity> findByExternalIdAndType(String authorisationId, AuthorisationType authorisationType) {
        return this.authorisationRepository.findByExternalIdAndType(authorisationId, authorisationType);
    }

    public AuthorisationEntity prepareAuthorisationEntity(Authorisable authorisationParent, CreateAuthorisationRequest request, Optional<PsuData> psuDataOptional, AuthorisationType authorisationType, long redirectUrlExpirationTimeMs, long authorisationExpirationTimeMs) {
        return this.authorisationMapper.prepareAuthorisationEntity(authorisationParent, request, psuDataOptional, authorisationType, redirectUrlExpirationTimeMs, authorisationExpirationTimeMs);
    }

    public AuthorisationEntity save(AuthorisationEntity entity) {
        return (AuthorisationEntity)this.authorisationRepository.save(entity);
    }

    @ConstructorProperties(value={"authorisationMapper", "authorisationRepository"})
    public AuthorisationService(AuthorisationMapper authorisationMapper, AuthorisationRepository authorisationRepository) {
        this.authorisationMapper = authorisationMapper;
        this.authorisationRepository = authorisationRepository;
    }
}

