/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.aspsp.profile.service.AspspProfileService;
import de.adorsys.psd2.consent.api.ais.CmsConsent;
import de.adorsys.psd2.consent.domain.account.AisConsentTransaction;
import de.adorsys.psd2.consent.repository.AisConsentTransactionRepository;
import de.adorsys.psd2.consent.repository.AisConsentUsageRepository;
import de.adorsys.psd2.consent.service.mapper.CmsAisConsentMapper;
import de.adorsys.psd2.core.data.AccountAccess;
import de.adorsys.psd2.xs2a.core.ais.BookingStatus;
import de.adorsys.psd2.xs2a.core.consent.AisConsentRequestType;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.core.profile.AdditionalInformationAccess;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class OneOffConsentExpirationService {
    public static final String BENEFICIARIES_URI = "/v1/trusted-beneficiaries";
    public static final int READ_ONLY_ACCOUNT_DETAILS_COUNT = 1;
    public static final int READ_ACCOUNT_DETAILS_AND_BALANCES_COUNT = 2;
    public static final int READ_ALL_DETAILS_AND_BENEFICIARIES = 3;
    private final AisConsentUsageRepository aisConsentUsageRepository;
    private final AisConsentTransactionRepository aisConsentTransactionRepository;
    private final CmsAisConsentMapper cmsAisConsentMapper;
    private final AspspProfileService aspspProfileService;

    public boolean isConsentExpired(CmsConsent cmsConsent, Long consentId) {
        AisConsentRequestType consentRequestType = this.cmsAisConsentMapper.mapToAisConsent(cmsConsent).getConsentRequestType();
        if (consentRequestType == AisConsentRequestType.BANK_OFFERED) {
            return false;
        }
        if (consentRequestType == AisConsentRequestType.ALL_AVAILABLE_ACCOUNTS) {
            return true;
        }
        AccountAccess aspspAccountAccesses = cmsConsent.getAspspAccountAccesses();
        List references = Stream.of(aspspAccountAccesses.getAccounts(), aspspAccountAccesses.getBalances(), aspspAccountAccesses.getTransactions()).flatMap(Collection::stream).collect(Collectors.toList());
        List consentResourceIds = references.stream().map(AccountReference::getResourceId).distinct().collect(Collectors.toList());
        boolean isExpired = true;
        for (String resourceId : consentResourceIds) {
            List bookingStatuses = this.aspspProfileService.getAspspSettings(cmsConsent.getInstanceId()).getAis().getTransactionParameters().getAvailableBookingStatuses();
            List<AisConsentTransaction> consentTransactions = this.aisConsentTransactionRepository.findByConsentIdAndResourceId(consentId, resourceId, Pageable.unpaged()).stream().filter(t -> bookingStatuses.contains(t.getBookingStatus())).collect(Collectors.toList());
            int numberOfTransactions = this.getNumberOfTransactions(consentTransactions);
            boolean isConsentGlobal = consentRequestType == AisConsentRequestType.GLOBAL;
            int totalPages = this.getTotalPages(consentTransactions, bookingStatuses);
            int maximumNumberOfGetRequestsForConsent = this.getMaximumNumberOfGetRequestsForConsentsAccount(aspspAccountAccesses, resourceId, numberOfTransactions, isConsentGlobal, cmsConsent.getInstanceId(), totalPages);
            int numberOfUsedGetRequestsForConsent = this.getNumberOfUsedGetRequestsForConsent(consentId, resourceId);
            if (numberOfUsedGetRequestsForConsent >= maximumNumberOfGetRequestsForConsent) continue;
            isExpired = false;
            break;
        }
        return isExpired;
    }

    private int getNumberOfTransactions(List<AisConsentTransaction> consentTransactions) {
        Set bookingStatuses = consentTransactions.stream().map(AisConsentTransaction::getBookingStatus).collect(Collectors.toSet());
        EnumSet<BookingStatus> filteredBookingStatuses = bookingStatuses.contains(BookingStatus.BOTH) ? EnumSet.of(BookingStatus.BOTH) : EnumSet.of(BookingStatus.BOOKED, BookingStatus.PENDING);
        return consentTransactions.stream().filter(t -> filteredBookingStatuses.contains(t.getBookingStatus())).map(AisConsentTransaction::getNumberOfTransactions).mapToInt(Integer::intValue).sum();
    }

    private int getTotalPages(List<AisConsentTransaction> consentTransactions, List<BookingStatus> bookingStatuses) {
        Map<BookingStatus, Integer> map = consentTransactions.stream().collect(Collectors.toMap(AisConsentTransaction::getBookingStatus, AisConsentTransaction::getTotalPages, Math::max));
        int result = 0;
        for (BookingStatus bs : bookingStatuses) {
            result += map.getOrDefault(bs, 1).intValue();
        }
        return result;
    }

    private int getNumberOfUsedGetRequestsForConsent(Long consentId, String resourceId) {
        int numberOfUsedGetRequestsForConsent = this.aisConsentUsageRepository.countByConsentIdAndResourceId(consentId, resourceId);
        int numberOfUsedGetRequestsForBeneficiaries = this.aisConsentUsageRepository.countByConsentIdAndRequestUri(consentId, BENEFICIARIES_URI);
        return numberOfUsedGetRequestsForConsent + numberOfUsedGetRequestsForBeneficiaries;
    }

    private int getMaximumNumberOfGetRequestsForConsentsAccount(AccountAccess aspspAccountAccesses, String resourceId, int numberOfTransactions, boolean isConsentGlobal, String instanceId, int totalPages) {
        boolean accessesForAccountsEmpty = this.isAccessForAccountReferencesEmpty(aspspAccountAccesses.getAccounts(), resourceId);
        boolean accessesForBalanceEmpty = this.isAccessForAccountReferencesEmpty(aspspAccountAccesses.getBalances(), resourceId);
        boolean accessesForTransactionsEmpty = this.isAccessForAccountReferencesEmpty(aspspAccountAccesses.getTransactions(), resourceId);
        if (!accessesForAccountsEmpty && accessesForBalanceEmpty && accessesForTransactionsEmpty) {
            return 1;
        }
        if (accessesForTransactionsEmpty) {
            return 2;
        }
        if (accessesForBalanceEmpty) {
            return 1 + totalPages + numberOfTransactions;
        }
        if (this.isBeneficiariesEndpointAllowed(isConsentGlobal, aspspAccountAccesses, instanceId)) {
            return 3 + totalPages + numberOfTransactions;
        }
        return 2 + totalPages + numberOfTransactions;
    }

    private boolean isBeneficiariesEndpointAllowed(boolean isConsentGlobal, AccountAccess aspspAccountAccesses, String instanceId) {
        return this.isGlobalConsentWithBeneficiaries(isConsentGlobal, instanceId) || !this.isTrustedBeneficiariesNotAllowed(aspspAccountAccesses);
    }

    private boolean isGlobalConsentWithBeneficiaries(boolean isConsentGlobal, String instanceId) {
        return isConsentGlobal && this.isTrustedBeneficiariesSupported(instanceId);
    }

    private boolean isTrustedBeneficiariesNotAllowed(AccountAccess aspspAccountAccesses) {
        AdditionalInformationAccess additionalInformationAccess = aspspAccountAccesses.getAdditionalInformationAccess();
        return additionalInformationAccess == null || additionalInformationAccess.getTrustedBeneficiaries() == null;
    }

    private boolean isAccessForAccountReferencesEmpty(List<AccountReference> accounts, String resourceId) {
        return accounts.stream().noneMatch(access -> access.getResourceId().equals(resourceId));
    }

    public boolean isTrustedBeneficiariesSupported(String instanceId) {
        return this.aspspProfileService.getAspspSettings(instanceId).getAis().getConsentTypes().isTrustedBeneficiariesSupported();
    }

    @ConstructorProperties(value={"aisConsentUsageRepository", "aisConsentTransactionRepository", "cmsAisConsentMapper", "aspspProfileService"})
    public OneOffConsentExpirationService(AisConsentUsageRepository aisConsentUsageRepository, AisConsentTransactionRepository aisConsentTransactionRepository, CmsAisConsentMapper cmsAisConsentMapper, AspspProfileService aspspProfileService) {
        this.aisConsentUsageRepository = aisConsentUsageRepository;
        this.aisConsentTransactionRepository = aisConsentTransactionRepository;
        this.cmsAisConsentMapper = cmsAisConsentMapper;
        this.aspspProfileService = aspspProfileService;
    }
}

