/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.repository.specification;

import de.adorsys.psd2.consent.repository.specification.EntityAttributeSpecificationProvider;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Optional;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class CommonSpecification<T> {
    public Specification<T> byPsuIdDataAndCreationPeriodAndInstanceId(@NotNull PsuIdData psuIdData, @Nullable LocalDate createDateFrom, @Nullable LocalDate createDateTo, @Nullable String instanceId) {
        return Optional.of(Specification.where(this.byPsuIdDataInList(psuIdData))).map(s -> s.and(this.byCreationTimestamp(createDateFrom, createDateTo))).map(s -> s.and(this.byInstanceId(instanceId))).orElse(null);
    }

    protected Specification<T> byPsuIdDataInList(@Nullable PsuIdData psuIdData) {
        return this.byPsuIdData(psuIdData);
    }

    private Specification<T> byPsuIdData(@Nullable PsuIdData psuIdData) {
        if (psuIdData == null) {
            return null;
        }
        return (Specification & Serializable)(root, query, cb) -> {
            Join psuDataJoin = root.join("psuDataList");
            return Optional.of(Specification.where(EntityAttributeSpecificationProvider.provideSpecificationForJoinedEntityAttribute(psuDataJoin, "psuId", psuIdData.getPsuId()))).map(s -> s.and(EntityAttributeSpecificationProvider.provideSpecificationForJoinedEntityAttribute(psuDataJoin, "psuIdType", psuIdData.getPsuIdType()))).map(s -> s.and(EntityAttributeSpecificationProvider.provideSpecificationForJoinedEntityAttribute(psuDataJoin, "psuCorporateId", psuIdData.getPsuCorporateId()))).map(s -> s.and(EntityAttributeSpecificationProvider.provideSpecificationForJoinedEntityAttribute(psuDataJoin, "psuCorporateIdType", psuIdData.getPsuCorporateIdType()))).map(s -> s.toPredicate(root, query, cb)).orElse(null);
        };
    }

    protected Specification<T> byInstanceId(@Nullable String instanceId) {
        return EntityAttributeSpecificationProvider.provideSpecificationForEntityAttribute("instanceId", instanceId);
    }

    protected Specification<T> byCreationTimestamp(@Nullable LocalDate start, @Nullable LocalDate end) {
        ZoneOffset currentOffset = OffsetDateTime.now().getOffset();
        OffsetDateTime startOffsetDateTime = Optional.ofNullable(start).map(odt -> OffsetDateTime.of(odt, LocalTime.MIN, currentOffset)).orElse(null);
        OffsetDateTime endOffsetDateTime = Optional.ofNullable(end).map(odt -> OffsetDateTime.of(odt, LocalTime.MAX, currentOffset)).orElse(null);
        return this.byCreationTimestamp(startOffsetDateTime, endOffsetDateTime);
    }

    private Specification<T> byCreationTimestamp(@Nullable OffsetDateTime start, @Nullable OffsetDateTime end) {
        return (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
            criteriaQuery.orderBy(new Order[]{criteriaBuilder.asc((Expression)root.get("creationTimestamp"))});
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (start != null) {
                predicates.add(criteriaBuilder.greaterThanOrEqualTo((Expression)root.get("creationTimestamp"), (Comparable)start));
            }
            if (end != null) {
                predicates.add(criteriaBuilder.lessThanOrEqualTo((Expression)root.get("creationTimestamp"), (Comparable)end));
            }
            return criteriaBuilder.and(predicates.toArray(new Predicate[0]));
        };
    }
}

