/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.mapper;

import de.adorsys.psd2.consent.domain.AuthorisationTemplateEntity;
import de.adorsys.psd2.consent.service.mapper.AuthorisationTemplateMapper;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationTemplate;
import de.adorsys.psd2.xs2a.core.tpp.TppRedirectUri;
import org.springframework.stereotype.Component;

@Component
public class AuthorisationTemplateMapperImpl
implements AuthorisationTemplateMapper {
    @Override
    public AuthorisationTemplate mapToAuthorisationTemplate(AuthorisationTemplateEntity entity) {
        if (entity == null) {
            return null;
        }
        AuthorisationTemplate authorisationTemplate = new AuthorisationTemplate();
        authorisationTemplate.setTppRedirectUri(this.createTppRedirectUri(entity.getRedirectUri(), entity.getNokRedirectUri()));
        authorisationTemplate.setCancelTppRedirectUri(this.createTppRedirectUri(entity.getCancelRedirectUri(), entity.getCancelNokRedirectUri()));
        return authorisationTemplate;
    }

    @Override
    public AuthorisationTemplateEntity mapToAuthorisationTemplateEntity(AuthorisationTemplate authorisationTemplate) {
        if (authorisationTemplate == null) {
            return null;
        }
        AuthorisationTemplateEntity authorisationTemplateEntity = new AuthorisationTemplateEntity();
        authorisationTemplateEntity.setRedirectUri(this.getUriOrNull(authorisationTemplate.getTppRedirectUri(), TppRedirectUri::getUri));
        authorisationTemplateEntity.setNokRedirectUri(this.getUriOrNull(authorisationTemplate.getTppRedirectUri(), TppRedirectUri::getNokUri));
        authorisationTemplateEntity.setCancelRedirectUri(this.getUriOrNull(authorisationTemplate.getCancelTppRedirectUri(), TppRedirectUri::getUri));
        authorisationTemplateEntity.setCancelNokRedirectUri(this.getUriOrNull(authorisationTemplate.getCancelTppRedirectUri(), TppRedirectUri::getNokUri));
        return authorisationTemplateEntity;
    }
}

