/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.api.AspspDataService;
import de.adorsys.psd2.consent.domain.AspspConsentDataEntity;
import de.adorsys.psd2.consent.repository.AspspConsentDataRepository;
import de.adorsys.psd2.consent.service.security.EncryptedData;
import de.adorsys.psd2.consent.service.security.SecurityDataService;
import de.adorsys.psd2.xs2a.core.consent.AspspConsentData;
import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class AspspDataServiceInternal
implements AspspDataService {
    private static final Logger log = LoggerFactory.getLogger(AspspDataServiceInternal.class);
    private final SecurityDataService securityDataService;
    private final AspspConsentDataRepository aspspConsentDataRepository;

    @NotNull
    public Optional<AspspConsentData> readAspspConsentData(@NotNull String externalId) {
        if (!this.securityDataService.isConsentIdEncrypted(externalId)) {
            return this.aspspConsentDataRepository.findByConsentId(externalId).map(aspspConsentDataEntity -> new AspspConsentData(aspspConsentDataEntity.getData(), externalId));
        }
        return this.getAspspConsentDataEntity(externalId).map(AspspConsentDataEntity::getData).flatMap(data -> this.securityDataService.decryptConsentData(externalId, (byte[])data)).map(dta -> new AspspConsentData(dta.getData(), externalId));
    }

    @Transactional
    public boolean updateAspspConsentData(@NotNull AspspConsentData aspspConsentData) {
        if (aspspConsentData.isEmptyConsentData()) {
            log.info("Update Aspsp consent data failed, because aspsp Consent data is empty.");
            return false;
        }
        byte[] data = aspspConsentData.getAspspConsentDataBytes();
        if (Objects.isNull(data)) {
            return this.deleteAspspConsentData(aspspConsentData.getConsentId());
        }
        String encryptedConsentId = aspspConsentData.getConsentId();
        if (!this.securityDataService.isConsentIdEncrypted(encryptedConsentId)) {
            return this.updateAndSaveAspspConsentData(encryptedConsentId, data);
        }
        Optional<String> decryptConsentId = this.securityDataService.decryptId(encryptedConsentId);
        if (decryptConsentId.isEmpty()) {
            log.info("Consent ID: [{}]. Update Aspsp consent data failed, because consent id cannot be decrypted.", (Object)encryptedConsentId);
            return false;
        }
        Optional<EncryptedData> encryptedData = this.securityDataService.encryptConsentData(encryptedConsentId, data);
        if (encryptedData.isEmpty()) {
            log.info("Consent ID: [{}]. Update Aspsp consent data failed, because aspsp consent data cannot be encrypted.", (Object)encryptedConsentId);
            return false;
        }
        return this.updateAndSaveAspspConsentData(decryptConsentId.get(), encryptedData.get().getData());
    }

    @Transactional
    public boolean deleteAspspConsentData(@NotNull String externalId) {
        if (!this.securityDataService.isConsentIdEncrypted(externalId)) {
            return this.deleteAspspConsentDataIfExist(externalId);
        }
        return this.securityDataService.decryptId(externalId).map(this::deleteAspspConsentDataIfExist).orElseGet(() -> {
            log.info("External Consent ID: [{}]. Delete aspsp consent data failed, couldn't decrypt consent id", (Object)externalId);
            return false;
        });
    }

    private boolean deleteAspspConsentDataIfExist(@NotNull String consentId) {
        if (this.aspspConsentDataRepository.existsById(consentId)) {
            this.aspspConsentDataRepository.deleteById(consentId);
            return true;
        }
        log.info("Consent ID: [{}]. Delete Aspsp consent data failed, because aspsp consent data for this consent id does not exist.", (Object)consentId);
        return false;
    }

    private Optional<AspspConsentDataEntity> getAspspConsentDataEntity(String externalId) {
        return this.securityDataService.decryptId(externalId).flatMap(this.aspspConsentDataRepository::findByConsentId);
    }

    private boolean updateAndSaveAspspConsentData(String consentId, byte[] encryptConsentData) {
        AspspConsentDataEntity aspspConsentDataEntity = this.aspspConsentDataRepository.findByConsentId(consentId).orElseGet(() -> new AspspConsentDataEntity(consentId));
        aspspConsentDataEntity.setData(encryptConsentData);
        return this.aspspConsentDataRepository.save(aspspConsentDataEntity) != null;
    }

    @ConstructorProperties(value={"securityDataService", "aspspConsentDataRepository"})
    public AspspDataServiceInternal(SecurityDataService securityDataService, AspspConsentDataRepository aspspConsentDataRepository) {
        this.securityDataService = securityDataService;
        this.aspspConsentDataRepository = aspspConsentDataRepository;
    }
}

