/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.aspsp.profile.service.AspspProfileService;
import de.adorsys.psd2.consent.domain.AuthorisationEntity;
import de.adorsys.psd2.consent.domain.consent.ConsentEntity;
import de.adorsys.psd2.consent.repository.AuthorisationRepository;
import de.adorsys.psd2.consent.repository.ConsentJpaRepository;
import de.adorsys.psd2.consent.service.AisConsentConfirmationExpirationService;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationType;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.IterableUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AisConsentConfirmationExpirationServiceImpl
implements AisConsentConfirmationExpirationService {
    private static final Logger log = LoggerFactory.getLogger(AisConsentConfirmationExpirationServiceImpl.class);
    private final ConsentJpaRepository consentJpaRepository;
    private final AuthorisationRepository authorisationRepository;
    private final AspspProfileService aspspProfileService;

    @Override
    @Transactional
    public ConsentEntity checkAndUpdateOnConfirmationExpiration(ConsentEntity consent) {
        if (this.isConfirmationExpired(consent)) {
            log.info("Consent ID: [{}]. Consent is expired", (Object)consent.getExternalId());
            return this.updateOnConfirmationExpiration(consent);
        }
        return consent;
    }

    @Override
    public boolean isConfirmationExpired(ConsentEntity consent) {
        if (consent == null) {
            return false;
        }
        long expirationPeriodMs = this.aspspProfileService.getAspspSettings(consent.getInstanceId()).getAis().getConsentTypes().getNotConfirmedConsentExpirationTimeMs();
        return consent.isConfirmationExpired(expirationPeriodMs);
    }

    @Override
    @Transactional
    public ConsentEntity expireConsent(ConsentEntity consent) {
        LocalDate now = LocalDate.now();
        consent.setConsentStatus(ConsentStatus.EXPIRED);
        consent.setExpireDate(now);
        consent.setLastActionDate(now);
        return (ConsentEntity)this.consentJpaRepository.save(consent);
    }

    @Override
    @Transactional
    public ConsentEntity updateOnConfirmationExpiration(ConsentEntity consent) {
        return (ConsentEntity)this.consentJpaRepository.save(this.obsoleteConsent(consent));
    }

    @Override
    @Transactional
    public List<ConsentEntity> updateConsentListOnConfirmationExpiration(List<ConsentEntity> consents) {
        return IterableUtils.toList((Iterable)this.consentJpaRepository.saveAll(this.obsoleteConsentList(consents)));
    }

    private List<ConsentEntity> obsoleteConsentList(List<ConsentEntity> consents) {
        return consents.stream().map(this::obsoleteConsent).collect(Collectors.toList());
    }

    private ConsentEntity obsoleteConsent(ConsentEntity consent) {
        consent.setConsentStatus(ConsentStatus.REJECTED);
        List<AuthorisationEntity> authorisations = this.authorisationRepository.findAllByParentExternalIdAndType(consent.getExternalId(), AuthorisationType.CONSENT);
        authorisations.forEach(auth -> auth.setScaStatus(ScaStatus.FAILED));
        this.authorisationRepository.saveAll(authorisations);
        consent.setLastActionDate(LocalDate.now());
        return consent;
    }

    @ConstructorProperties(value={"consentJpaRepository", "authorisationRepository", "aspspProfileService"})
    public AisConsentConfirmationExpirationServiceImpl(ConsentJpaRepository consentJpaRepository, AuthorisationRepository authorisationRepository, AspspProfileService aspspProfileService) {
        this.consentJpaRepository = consentJpaRepository;
        this.authorisationRepository = authorisationRepository;
        this.aspspProfileService = aspspProfileService;
    }
}

