/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.repository.specification;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Predicate;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.jpa.domain.Specification;

public class EntityAttributeSpecificationProvider {
    private EntityAttributeSpecificationProvider() {
    }

    public static <T> Specification<T> provideSpecificationForEntityAttribute(String attribute, String value) {
        return (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
            if (StringUtils.isBlank((CharSequence)value)) {
                return null;
            }
            return criteriaBuilder.and(new Predicate[]{criteriaBuilder.equal((Expression)root.get(attribute), (Object)value)});
        };
    }

    public static <T> Specification<T> provideSpecificationForEntityAttributeInList(String attribute, List<String> values) {
        return (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
            if (CollectionUtils.isEmpty((Collection)values)) {
                return null;
            }
            return criteriaBuilder.and(new Predicate[]{criteriaBuilder.in((Expression)root.get(attribute)).value((Object)values)});
        };
    }

    public static <T> Specification<T> provideSpecificationForJoinedEntityAttribute(@NotNull Join<T, ?> join, @NotNull String attribute, @Nullable String value) {
        return (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
            if (StringUtils.isBlank((CharSequence)value)) {
                return null;
            }
            return criteriaBuilder.and(new Predicate[]{criteriaBuilder.equal((Expression)join.get(attribute), (Object)value)});
        };
    }

    public static <T> Specification<T> provideSpecificationForJoinedEntityAttributeIn(@NotNull Join<T, ?> join, @NotNull String attribute, @Nullable List<String> values) {
        return (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
            if (CollectionUtils.isEmpty((Collection)values)) {
                return null;
            }
            return criteriaBuilder.and(new Predicate[]{join.get(attribute).in((Collection)values)});
        };
    }

    public static <T> Specification<T> provideSpecificationForJoinedEntityAttribute(@NotNull Join<T, ?> join, @NotNull String attribute, @Nullable Object value) {
        return (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> value == null ? criteriaBuilder.and(new Predicate[]{criteriaBuilder.isNull((Expression)join.get(attribute))}) : criteriaBuilder.and(new Predicate[]{criteriaBuilder.equal((Expression)join.get(attribute), value)});
    }
}

