/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.security;

import de.adorsys.psd2.consent.service.security.DecryptedData;
import de.adorsys.psd2.consent.service.security.DecryptedIdSet;
import de.adorsys.psd2.consent.service.security.EncryptedData;
import de.adorsys.psd2.consent.service.security.provider.CryptoProvider;
import de.adorsys.psd2.consent.service.security.provider.CryptoProviderHolder;
import java.beans.ConstructorProperties;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Optional;
import java.util.Random;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class SecurityDataService {
    private static final Logger log = LoggerFactory.getLogger(SecurityDataService.class);
    private static final String SEPARATOR = "_=_";
    private String serverKey;
    private final CryptoProviderHolder cryptoProviderHolder;
    private final SecureRandom random = new SecureRandom();

    @Autowired
    public SecurityDataService(Environment environment, CryptoProviderHolder cryptoProviderHolder) {
        this.cryptoProviderHolder = cryptoProviderHolder;
        this.serverKey = environment.getProperty("server_key");
        if (StringUtils.isBlank((CharSequence)this.serverKey)) {
            log.info("The 'server_key' missing - must be specified at CMS start");
            throw new IllegalArgumentException("CMS_SERVER_KEY_MISSING");
        }
    }

    public Optional<String> encryptId(String originalId) {
        String consentKey = RandomStringUtils.random((int)16, (int)0, (int)0, (boolean)true, (boolean)true, null, (Random)this.random);
        String compositeConsentId = this.concatWithSeparator(originalId, consentKey, this.cryptoProviderHolder.getDefaultDataProvider().getCryptoProviderId());
        byte[] bytesCompositeConsentId = compositeConsentId.getBytes();
        Optional<String> encryptedId = this.cryptoProviderHolder.getDefaultIdProvider().encryptData(bytesCompositeConsentId, this.serverKey).map(EncryptedData::getData).map(raw -> Base64.getUrlEncoder().encodeToString((byte[])raw)).map(this::addVersionToEncryptedId);
        if (encryptedId.isEmpty()) {
            log.info("ID: [{}]. Couldn't encrypt ID", (Object)originalId);
        }
        return encryptedId;
    }

    public Optional<String> decryptId(String encryptedId) {
        if (!encryptedId.contains(SEPARATOR)) {
            log.info("ID: [{}]. Couldn't decrypt, because id does not contain separator [{}]", (Object)encryptedId, (Object)SEPARATOR);
            return Optional.empty();
        }
        Optional<String> decryptedId = this.decryptCompositeId(encryptedId).map(cmst -> cmst.split(SEPARATOR)[0]);
        if (decryptedId.isEmpty()) {
            log.info("ID: [{}]. Couldn't decrypt ID", (Object)encryptedId);
        }
        return decryptedId;
    }

    public Optional<EncryptedData> encryptConsentData(String encryptedId, byte[] aspspConsentData) {
        return this.getDecryptedIdSetByEncryptedId(encryptedId).flatMap(dta -> this.getEncryptedData((DecryptedIdSet)dta, aspspConsentData));
    }

    public Optional<DecryptedData> decryptConsentData(String encryptedId, byte[] aspspConsentData) {
        return this.getDecryptedIdSetByEncryptedId(encryptedId).flatMap(dta -> this.getDecryptedData((DecryptedIdSet)dta, aspspConsentData));
    }

    public boolean isConsentIdEncrypted(String consentId) {
        return consentId.contains(SEPARATOR);
    }

    private Optional<DecryptedData> getDecryptedData(DecryptedIdSet decryptedIdSet, byte[] aspspConsentData) {
        return this.cryptoProviderHolder.getProviderById(decryptedIdSet.getDataEncryptionProviderId()).flatMap(provider -> provider.decryptData(aspspConsentData, decryptedIdSet.getRandomSecretKey()));
    }

    private Optional<EncryptedData> getEncryptedData(DecryptedIdSet decryptedIdSet, byte[] aspspConsentData) {
        return this.cryptoProviderHolder.getProviderById(decryptedIdSet.getDataEncryptionProviderId()).flatMap(provider -> provider.encryptData(aspspConsentData, decryptedIdSet.getRandomSecretKey()));
    }

    private Optional<DecryptedIdSet> getDecryptedIdSetByEncryptedId(String encryptedId) {
        return this.decryptCompositeId(encryptedId).map(cmpid -> new DecryptedIdSet(cmpid.split(SEPARATOR)));
    }

    private Optional<String> decryptCompositeId(String encryptedId) {
        String encryptedCompositeId = encryptedId.substring(0, encryptedId.indexOf(SEPARATOR));
        byte[] bytesCompositeId = this.decode64(encryptedCompositeId);
        if (bytesCompositeId == null) {
            log.info("ID: [{}]. Couldn't decrypt composite id", (Object)encryptedId);
            return Optional.empty();
        }
        String algorithmVersion = encryptedId.substring(encryptedId.indexOf(SEPARATOR) + SEPARATOR.length());
        Optional<CryptoProvider> provider = this.cryptoProviderHolder.getProviderById(algorithmVersion);
        return provider.flatMap(prd -> prd.decryptData(bytesCompositeId, this.serverKey)).map(ed -> new String(ed.getData())).filter(StringUtils::isAsciiPrintable);
    }

    private byte[] decode64(String raw) {
        try {
            return Base64.getUrlDecoder().decode(raw);
        }
        catch (IllegalArgumentException ex) {
            log.info("ID: [{}]. Input id has wrong format", (Object)raw);
            return new byte[0];
        }
    }

    private String addVersionToEncryptedId(String encryptedId) {
        String algorithmVersion = this.cryptoProviderHolder.getDefaultIdProvider().getCryptoProviderId();
        return this.concatWithSeparator(encryptedId, algorithmVersion);
    }

    private String concatWithSeparator(String ... parts) {
        return StringUtils.join((Object[])parts, (String)SEPARATOR);
    }

    @ConstructorProperties(value={"cryptoProviderHolder"})
    public SecurityDataService(CryptoProviderHolder cryptoProviderHolder) {
        this.cryptoProviderHolder = cryptoProviderHolder;
    }
}

