/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.security.provider;

import java.beans.ConstructorProperties;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public abstract class AbstractCryptoProvider {
    private final int keyLength;
    private final int hashIterations;
    private final String skfAlgorithm;
    private final String cryptoProviderId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SecretKey getSecretKey(String password) throws InvalidKeySpecException, NoSuchAlgorithmException {
        byte[] salt = new byte[16];
        PBEKeySpec keySpec = new PBEKeySpec(password.toCharArray(), salt, this.hashIterations, this.keyLength);
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance(this.skfAlgorithm);
            SecretKey secretKey = factory.generateSecret(keySpec);
            SecretKeySpec secretKeySpec = new SecretKeySpec(secretKey.getEncoded(), "AES");
            return secretKeySpec;
        }
        finally {
            keySpec.clearPassword();
        }
    }

    public String getCryptoProviderId() {
        return this.cryptoProviderId;
    }

    @ConstructorProperties(value={"keyLength", "hashIterations", "skfAlgorithm", "cryptoProviderId"})
    public AbstractCryptoProvider(int keyLength, int hashIterations, String skfAlgorithm, String cryptoProviderId) {
        this.keyLength = keyLength;
        this.hashIterations = hashIterations;
        this.skfAlgorithm = skfAlgorithm;
        this.cryptoProviderId = cryptoProviderId;
    }
}

