/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.psu;

import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.pis.CmsBasePaymentResponse;
import de.adorsys.psd2.consent.api.pis.CmsCommonPayment;
import de.adorsys.psd2.consent.api.pis.CmsPaymentResponse;
import de.adorsys.psd2.consent.api.service.PisCommonPaymentService;
import de.adorsys.psd2.consent.domain.AuthorisationEntity;
import de.adorsys.psd2.consent.domain.PsuData;
import de.adorsys.psd2.consent.domain.payment.PisCommonPaymentData;
import de.adorsys.psd2.consent.psu.api.CmsPsuAuthorisation;
import de.adorsys.psd2.consent.psu.api.CmsPsuPisService;
import de.adorsys.psd2.consent.psu.api.pis.CmsPisPsuDataAuthorisation;
import de.adorsys.psd2.consent.repository.AuthorisationRepository;
import de.adorsys.psd2.consent.repository.PisCommonPaymentDataRepository;
import de.adorsys.psd2.consent.repository.PisPaymentDataRepository;
import de.adorsys.psd2.consent.repository.specification.AuthorisationSpecification;
import de.adorsys.psd2.consent.repository.specification.PisPaymentDataSpecification;
import de.adorsys.psd2.consent.service.CommonPaymentDataService;
import de.adorsys.psd2.consent.service.CorePaymentsConvertService;
import de.adorsys.psd2.consent.service.mapper.CmsPsuAuthorisationMapper;
import de.adorsys.psd2.consent.service.mapper.CmsPsuPisMapper;
import de.adorsys.psd2.consent.service.mapper.PsuDataMapper;
import de.adorsys.psd2.consent.service.psu.CmsPsuService;
import de.adorsys.psd2.consent.service.psu.util.PageRequestBuilder;
import de.adorsys.psd2.consent.service.psu.util.PsuDataUpdater;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationType;
import de.adorsys.psd2.xs2a.core.exception.AuthorisationIsExpiredException;
import de.adorsys.psd2.xs2a.core.exception.RedirectUrlIsExpiredException;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.AuthenticationDataHolder;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import java.beans.ConstructorProperties;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CmsPsuPisServiceInternal
implements CmsPsuPisService {
    private static final Logger log = LoggerFactory.getLogger(CmsPsuPisServiceInternal.class);
    private final PisPaymentDataRepository pisPaymentDataRepository;
    private final PisCommonPaymentDataRepository pisCommonPaymentDataRepository;
    private final AuthorisationRepository authorisationRepository;
    private final CmsPsuPisMapper cmsPsuPisMapper;
    private final PisCommonPaymentService pisCommonPaymentService;
    private final CommonPaymentDataService commonPaymentDataService;
    private final PsuDataMapper psuDataMapper;
    private final AuthorisationSpecification authorisationSpecification;
    private final PisPaymentDataSpecification pisPaymentDataSpecification;
    private final CmsPsuService cmsPsuService;
    private final CmsPsuAuthorisationMapper cmsPsuPisAuthorisationMapper;
    private final CorePaymentsConvertService corePaymentsConvertService;
    private final PsuDataUpdater psuDataUpdater;
    private final PageRequestBuilder pageRequestBuilder;

    @Transactional
    public boolean updatePsuInPayment(@NotNull PsuIdData psuIdData, @NotNull String authorisationId, @NotNull String instanceId) throws AuthorisationIsExpiredException {
        return this.getAuthorisationByExternalId(authorisationId, instanceId).map(auth -> this.updatePsuData((AuthorisationEntity)auth, psuIdData)).orElseGet(() -> {
            log.info("Authorisation ID [{}], Instance ID: [{}]. Update PSU  in Payment failed, because authorisation not found", (Object)authorisationId, (Object)instanceId);
            return false;
        });
    }

    @Transactional
    @NotNull
    public Optional<CmsPaymentResponse> checkRedirectAndGetPayment(@NotNull String redirectId, @NotNull String instanceId) throws RedirectUrlIsExpiredException {
        Optional optionalAuthorisation = this.authorisationRepository.findOne(this.authorisationSpecification.byExternalIdAndInstanceId(redirectId, instanceId));
        if (optionalAuthorisation.isPresent()) {
            AuthorisationEntity authorisation = (AuthorisationEntity)optionalAuthorisation.get();
            if (!authorisation.isRedirectUrlNotExpired()) {
                log.info("Authorisation ID [{}], Instance ID: [{}]. Check redirect URL and get payment failed, because redirect URL is expired", (Object)authorisation.getExternalId(), (Object)instanceId);
                authorisation.setScaStatus(ScaStatus.FAILED);
                throw new RedirectUrlIsExpiredException(authorisation.getTppNokRedirectUri());
            }
            return this.buildCmsPaymentResponse(authorisation);
        }
        log.info("Authorisation ID [{}], Instance ID: [{}]. Check redirect URL and get payment failed, because authorisation not found or has finalised status", (Object)redirectId, (Object)instanceId);
        return Optional.empty();
    }

    @Transactional
    @NotNull
    public Optional<CmsBasePaymentResponse> getPayment(@NotNull PsuIdData psuIdData, @NotNull String paymentId, @NotNull String instanceId) {
        if (this.isPsuDataEquals(paymentId, psuIdData)) {
            List list = this.pisPaymentDataRepository.findAll(this.pisPaymentDataSpecification.byPaymentIdAndInstanceId(paymentId, instanceId));
            if (!list.isEmpty()) {
                return Optional.of(this.cmsPsuPisMapper.mapToCmsPayment(list));
            }
            return this.commonPaymentDataService.getPisCommonPaymentData(paymentId, instanceId).map(this.cmsPsuPisMapper::mapToCmsPayment).map(CmsCommonPayment.class::cast).map(this.corePaymentsConvertService::expandCommonPaymentWithCorePayment);
        }
        log.info("Payment ID: [{}], Instance ID: [{}]. Get payment failed, because given PSU data and PSU data stored in payment are not equal", (Object)paymentId, (Object)instanceId);
        return Optional.empty();
    }

    @Transactional
    @NotNull
    public Optional<CmsPaymentResponse> checkRedirectAndGetPaymentForCancellation(@NotNull String redirectId, @NotNull String instanceId) throws RedirectUrlIsExpiredException {
        Optional<AuthorisationEntity> optionalAuthorisation = this.authorisationRepository.findOne(this.authorisationSpecification.byExternalIdAndInstanceId(redirectId, instanceId)).filter(a -> !a.getScaStatus().isFinalisedStatus());
        if (optionalAuthorisation.isPresent()) {
            AuthorisationEntity authorisation = optionalAuthorisation.get();
            if (!authorisation.isRedirectUrlNotExpired()) {
                log.info("Authorisation ID [{}], Instance ID: [{}]. Check redirect URL and get payment cancellation failed, because authorisation not found or has finalised status", (Object)redirectId, (Object)instanceId);
                authorisation.setScaStatus(ScaStatus.FAILED);
                throw new RedirectUrlIsExpiredException(authorisation.getTppNokRedirectUri());
            }
            return this.buildCmsPaymentResponse(authorisation);
        }
        log.info("Authorisation ID [{}], Instance ID: [{}]. Check redirect URL and get payment cancellation failed, because authorisation not found or has finalised status", (Object)redirectId, (Object)instanceId);
        return Optional.empty();
    }

    @NotNull
    public Optional<CmsPsuAuthorisation> getAuthorisationByAuthorisationId(@NotNull String authorisationId, @NotNull String instanceId) {
        Optional optionalAuthorisation = this.authorisationRepository.findOne(this.authorisationSpecification.byExternalIdAndInstanceId(authorisationId, instanceId));
        if (optionalAuthorisation.isPresent()) {
            AuthorisationEntity authorisation = (AuthorisationEntity)optionalAuthorisation.get();
            return Optional.of(this.cmsPsuPisAuthorisationMapper.mapToCmsPsuAuthorisation(authorisation));
        }
        log.info("Authorisation ID: [{}], Instance ID: [{}]. Get authorisation failed, because authorisation not found", (Object)authorisationId, (Object)instanceId);
        return Optional.empty();
    }

    @Transactional
    public boolean updateAuthorisationStatus(@NotNull PsuIdData psuIdData, @NotNull String paymentId, @NotNull String authorisationId, @NotNull ScaStatus status, @NotNull String instanceId, AuthenticationDataHolder authenticationDataHolder) throws AuthorisationIsExpiredException {
        Optional<AuthorisationEntity> pisAuthorisation = this.getAuthorisationByExternalId(authorisationId, instanceId);
        if (pisAuthorisation.isEmpty()) {
            log.info("Authorisation ID [{}], Instance ID: [{}]. Update authorisation status failed, because authorisation not found.", (Object)authorisationId, (Object)instanceId);
            return false;
        }
        boolean isValid = pisAuthorisation.map(AuthorisationEntity::getParentExternalId).map(id -> this.validateGivenData((String)id, paymentId, psuIdData)).orElse(false);
        if (!isValid) {
            log.info("Authorisation ID [{}], Instance ID: [{}]. Update authorisation status failed, because request data is not valid", (Object)authorisationId, (Object)instanceId);
            return false;
        }
        return this.updateAuthorisationStatusAndSaveAuthorisation(pisAuthorisation.get(), status, authenticationDataHolder);
    }

    @Transactional
    public boolean updatePaymentStatus(@NotNull String paymentId, @NotNull TransactionStatus status, @NotNull String instanceId) {
        Optional<PisCommonPaymentData> paymentDataOptional = this.commonPaymentDataService.getPisCommonPaymentData(paymentId, instanceId);
        return paymentDataOptional.filter(p -> p.getTransactionStatus().isNotFinalisedStatus()).map(pd -> this.commonPaymentDataService.updateStatusInPaymentData((PisCommonPaymentData)pd, status)).orElseGet(() -> {
            log.info("Payment ID [{}], Instance ID: [{}]. Update payment status failed, because PIS common payment data not found", (Object)paymentId, (Object)instanceId);
            return false;
        });
    }

    public Optional<List<CmsPisPsuDataAuthorisation>> getPsuDataAuthorisations(@NotNull String paymentId, @NotNull String instanceId, Integer pageIndex, Integer itemsPerPage) {
        if (pageIndex == null && itemsPerPage == null) {
            return this.commonPaymentDataService.getPisCommonPaymentData(paymentId, instanceId).map(p -> this.authorisationRepository.findAllByParentExternalIdAndTypeIn(paymentId, EnumSet.of(AuthorisationType.PIS_CREATION, AuthorisationType.PIS_CANCELLATION))).map(this::getPsuDataAuthorisations);
        }
        Pageable pageRequest = this.pageRequestBuilder.getPageable(pageIndex, itemsPerPage);
        return this.commonPaymentDataService.getPisCommonPaymentData(paymentId, instanceId).map(p -> this.authorisationRepository.findAllByParentExternalIdAndTypeIn(paymentId, EnumSet.of(AuthorisationType.PIS_CREATION, AuthorisationType.PIS_CANCELLATION), pageRequest)).map(this::getPsuDataAuthorisations);
    }

    @NotNull
    private List<CmsPisPsuDataAuthorisation> getPsuDataAuthorisations(List<AuthorisationEntity> authorisations) {
        return authorisations.stream().filter(auth -> Objects.nonNull(auth.getPsuData())).map(auth -> new CmsPisPsuDataAuthorisation(this.psuDataMapper.mapToPsuIdData(auth.getPsuData()), auth.getExternalId(), auth.getScaStatus(), auth.getType())).collect(Collectors.toList());
    }

    private boolean updatePsuData(AuthorisationEntity authorisation, PsuIdData psuIdData) {
        PsuData newPsuData = this.psuDataMapper.mapToPsuData(psuIdData, authorisation.getInstanceId());
        if (newPsuData == null || StringUtils.isBlank((CharSequence)newPsuData.getPsuId())) {
            log.info("Authorisation ID [{}]. Update PSU in payment failed in updatePsuData method, because newPsuData or psuId in newPsuData is empty or null", (Object)authorisation.getExternalId());
            return false;
        }
        Optional<PsuData> optionalPsuData = Optional.ofNullable(authorisation.getPsuData());
        if (optionalPsuData.isPresent()) {
            newPsuData = this.psuDataUpdater.updatePsuDataEntity(optionalPsuData.get(), newPsuData);
        } else {
            Optional<PisCommonPaymentData> commonPaymentOptional = this.pisCommonPaymentDataRepository.findByPaymentId(authorisation.getParentExternalId());
            if (commonPaymentOptional.isEmpty()) {
                log.info("Authorisation ID [{}]. Update PSU data in payment failed, couldn't find payment by the parent ID in the authorisation.", (Object)authorisation.getExternalId());
                return false;
            }
            PisCommonPaymentData commonPayment = commonPaymentOptional.get();
            List<PsuData> paymentPsuList = commonPayment.getPsuDataList();
            Optional<PsuData> psuDataOptional = this.cmsPsuService.definePsuDataForAuthorisation(newPsuData, paymentPsuList);
            if (psuDataOptional.isPresent()) {
                newPsuData = psuDataOptional.get();
                if (AuthorisationType.PIS_CANCELLATION != authorisation.getType()) {
                    commonPayment.setPsuDataList(this.cmsPsuService.enrichPsuData(newPsuData, paymentPsuList));
                }
            }
            log.info("Authorisation ID [{}]. The payment attached to this authorisation, contains no PSU data with an ID that matches the requested one.", (Object)authorisation.getExternalId());
        }
        authorisation.setPsuData(newPsuData);
        return true;
    }

    private boolean validateGivenData(String realPaymentId, String givenPaymentId, PsuIdData psuIdData) {
        return Optional.of(givenPaymentId).filter(p -> this.isPsuDataEquals((String)p, psuIdData)).map(id -> StringUtils.equals((CharSequence)realPaymentId, (CharSequence)id)).orElseGet(() -> {
            log.info("Cannot validate given PSU data, because given payment ID is null");
            return false;
        });
    }

    private boolean updateAuthorisationStatusAndSaveAuthorisation(AuthorisationEntity pisAuthorisation, ScaStatus status, AuthenticationDataHolder authenticationDataHolder) {
        if (pisAuthorisation.getScaStatus().isFinalisedStatus()) {
            log.info("Authorisation ID [{}], SCA status: [{}]. Update authorisation status failed in updateAuthorisationStatusAndSaveAuthorisation method, because authorisation has finalised status", (Object)pisAuthorisation.getExternalId(), (Object)pisAuthorisation.getScaStatus().getValue());
            return false;
        }
        pisAuthorisation.setScaStatus(status);
        if (authenticationDataHolder != null) {
            this.enrichAuthorisationWithAuthenticationData(pisAuthorisation, authenticationDataHolder);
        }
        return true;
    }

    private boolean isPsuDataEquals(String paymentId, PsuIdData psuIdData) {
        CmsResponse psuDataResponse = this.pisCommonPaymentService.getPsuDataListByPaymentId(paymentId);
        if (psuDataResponse.hasError()) {
            log.info("Payment ID: [{}]. Cannot equal PSU data with payment ID, because PSU data list not found by ID", (Object)paymentId);
            return false;
        }
        return ((List)psuDataResponse.getPayload()).stream().anyMatch(psu -> psu.contentEquals(psuIdData));
    }

    private Optional<CmsPaymentResponse> buildCmsPaymentResponse(AuthorisationEntity authorisation) {
        Optional<PisCommonPaymentData> commonPayment = this.pisCommonPaymentDataRepository.findByPaymentId(authorisation.getParentExternalId());
        if (commonPayment.isEmpty()) {
            log.info("Authorisation ID [{}]. Creation of CMS payment response has failed, couldn't get payment by parent ID in authorisation", (Object)authorisation.getExternalId());
            return Optional.empty();
        }
        CmsBasePaymentResponse payment = this.cmsPsuPisMapper.mapPaymentDataToCmsPayment(commonPayment.get());
        CmsPaymentResponse cmsPaymentResponse = new CmsPaymentResponse(payment, authorisation.getExternalId(), authorisation.getTppOkRedirectUri(), authorisation.getTppNokRedirectUri());
        return Optional.of(cmsPaymentResponse);
    }

    private Optional<AuthorisationEntity> getAuthorisationByExternalId(@NotNull String authorisationId, @NotNull String instanceId) throws AuthorisationIsExpiredException {
        Optional authorization = this.authorisationRepository.findOne(this.authorisationSpecification.byExternalIdAndInstanceId(authorisationId, instanceId));
        if (authorization.isPresent() && !((AuthorisationEntity)authorization.get()).isAuthorisationNotExpired()) {
            log.info("Authorisation ID [{}], Instance ID: [{}]. Authorisation is expired", (Object)authorisationId, (Object)instanceId);
            throw new AuthorisationIsExpiredException(((AuthorisationEntity)authorization.get()).getTppNokRedirectUri());
        }
        return authorization;
    }

    private void enrichAuthorisationWithAuthenticationData(AuthorisationEntity authorisation, AuthenticationDataHolder authenticationDataHolder) {
        if (authenticationDataHolder.getAuthenticationData() != null) {
            authorisation.setScaAuthenticationData(authenticationDataHolder.getAuthenticationData());
        }
        if (authenticationDataHolder.getAuthenticationMethodId() != null) {
            authorisation.setAuthenticationMethodId(authenticationDataHolder.getAuthenticationMethodId());
        }
    }

    @ConstructorProperties(value={"pisPaymentDataRepository", "pisCommonPaymentDataRepository", "authorisationRepository", "cmsPsuPisMapper", "pisCommonPaymentService", "commonPaymentDataService", "psuDataMapper", "authorisationSpecification", "pisPaymentDataSpecification", "cmsPsuService", "cmsPsuPisAuthorisationMapper", "corePaymentsConvertService", "psuDataUpdater", "pageRequestBuilder"})
    public CmsPsuPisServiceInternal(PisPaymentDataRepository pisPaymentDataRepository, PisCommonPaymentDataRepository pisCommonPaymentDataRepository, AuthorisationRepository authorisationRepository, CmsPsuPisMapper cmsPsuPisMapper, PisCommonPaymentService pisCommonPaymentService, CommonPaymentDataService commonPaymentDataService, PsuDataMapper psuDataMapper, AuthorisationSpecification authorisationSpecification, PisPaymentDataSpecification pisPaymentDataSpecification, CmsPsuService cmsPsuService, CmsPsuAuthorisationMapper cmsPsuPisAuthorisationMapper, CorePaymentsConvertService corePaymentsConvertService, PsuDataUpdater psuDataUpdater, PageRequestBuilder pageRequestBuilder) {
        this.pisPaymentDataRepository = pisPaymentDataRepository;
        this.pisCommonPaymentDataRepository = pisCommonPaymentDataRepository;
        this.authorisationRepository = authorisationRepository;
        this.cmsPsuPisMapper = cmsPsuPisMapper;
        this.pisCommonPaymentService = pisCommonPaymentService;
        this.commonPaymentDataService = commonPaymentDataService;
        this.psuDataMapper = psuDataMapper;
        this.authorisationSpecification = authorisationSpecification;
        this.pisPaymentDataSpecification = pisPaymentDataSpecification;
        this.cmsPsuService = cmsPsuService;
        this.cmsPsuPisAuthorisationMapper = cmsPsuPisAuthorisationMapper;
        this.corePaymentsConvertService = corePaymentsConvertService;
        this.psuDataUpdater = psuDataUpdater;
        this.pageRequestBuilder = pageRequestBuilder;
    }
}

