/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.psu;

import de.adorsys.psd2.consent.api.piis.v1.CmsPiisConsent;
import de.adorsys.psd2.consent.domain.consent.ConsentEntity;
import de.adorsys.psd2.consent.psu.api.CmsPsuPiisService;
import de.adorsys.psd2.consent.repository.ConsentJpaRepository;
import de.adorsys.psd2.consent.repository.specification.PiisConsentEntitySpecification;
import de.adorsys.psd2.consent.service.mapper.PiisConsentMapper;
import de.adorsys.psd2.consent.service.mapper.PsuDataMapper;
import de.adorsys.psd2.consent.service.migration.PiisConsentLazyMigrationService;
import de.adorsys.psd2.consent.service.psu.util.PageRequestBuilder;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CmsPsuPiisServiceInternal
implements CmsPsuPiisService {
    private static final Logger log = LoggerFactory.getLogger(CmsPsuPiisServiceInternal.class);
    private final ConsentJpaRepository consentJpaRepository;
    private final PiisConsentMapper piisConsentMapper;
    private final PsuDataMapper psuDataMapper;
    private final PiisConsentEntitySpecification piisConsentEntitySpecification;
    private final PiisConsentLazyMigrationService piisConsentLazyMigrationService;
    private final PageRequestBuilder pageRequestBuilder;

    @NotNull
    public Optional<CmsPiisConsent> getConsent(@NotNull PsuIdData psuIdData, @NotNull String consentId, @NotNull String instanceId) {
        return this.consentJpaRepository.findOne(this.piisConsentEntitySpecification.byConsentIdAndInstanceId(consentId, instanceId)).filter(con -> this.isPsuIdDataContentEquals((ConsentEntity)con, psuIdData)).map(this.piisConsentLazyMigrationService::migrateIfNeeded).map(this.piisConsentMapper::mapToCmsPiisConsent);
    }

    @NotNull
    public List<CmsPiisConsent> getConsentsForPsu(@NotNull PsuIdData psuIdData, @NotNull String instanceId, Integer pageIndex, Integer itemsPerPage) {
        if (pageIndex == null && itemsPerPage == null) {
            return this.consentJpaRepository.findAll(this.piisConsentEntitySpecification.byPsuDataAndInstanceId(psuIdData, instanceId)).stream().filter(con -> this.isPsuIdDataContentEquals((ConsentEntity)con, psuIdData)).map(this.piisConsentLazyMigrationService::migrateIfNeeded).map(this.piisConsentMapper::mapToCmsPiisConsent).collect(Collectors.toList());
        }
        Pageable pageRequest = this.pageRequestBuilder.getPageable(pageIndex, itemsPerPage);
        return this.consentJpaRepository.findAll(this.piisConsentEntitySpecification.byPsuDataAndInstanceId(psuIdData, instanceId), pageRequest).stream().filter(con -> this.isPsuIdDataContentEquals((ConsentEntity)con, psuIdData)).map(this.piisConsentLazyMigrationService::migrateIfNeeded).map(this.piisConsentMapper::mapToCmsPiisConsent).collect(Collectors.toList());
    }

    @Transactional
    public boolean revokeConsent(@NotNull PsuIdData psuIdData, @NotNull String consentId, @NotNull String instanceId) {
        Optional<ConsentEntity> piisConsentEntity = this.consentJpaRepository.findOne(this.piisConsentEntitySpecification.byConsentIdAndInstanceId(consentId, instanceId)).filter(con -> this.isPsuIdDataContentEquals((ConsentEntity)con, psuIdData) && !con.getConsentStatus().isFinalisedStatus());
        if (piisConsentEntity.isPresent()) {
            this.revokeConsent(piisConsentEntity.get());
            return true;
        }
        log.info("Consent ID [{}], Instance ID: [{}]. Revoke consent failed, because given psuData is not equals stored psuData, or consent status is finalised, or consent not found", (Object)consentId, (Object)instanceId);
        return false;
    }

    private boolean isPsuIdDataContentEquals(ConsentEntity piisConsentEntity, PsuIdData psuIdData) {
        List psuIdDataInConsent = piisConsentEntity.getPsuDataList().stream().map(this.psuDataMapper::mapToPsuIdData).filter(Objects::nonNull).collect(Collectors.toList());
        if (psuIdDataInConsent.isEmpty()) {
            log.info("PIIS Consent ID [{}]. Consent doesn't contain any PSU Data", (Object)piisConsentEntity.getExternalId());
            return false;
        }
        return psuIdDataInConsent.stream().anyMatch(consentPsu -> consentPsu.contentEquals(psuIdData));
    }

    private void revokeConsent(ConsentEntity consent) {
        consent.setLastActionDate(LocalDate.now());
        consent.setConsentStatus(ConsentStatus.REVOKED_BY_PSU);
    }

    @ConstructorProperties(value={"consentJpaRepository", "piisConsentMapper", "psuDataMapper", "piisConsentEntitySpecification", "piisConsentLazyMigrationService", "pageRequestBuilder"})
    public CmsPsuPiisServiceInternal(ConsentJpaRepository consentJpaRepository, PiisConsentMapper piisConsentMapper, PsuDataMapper psuDataMapper, PiisConsentEntitySpecification piisConsentEntitySpecification, PiisConsentLazyMigrationService piisConsentLazyMigrationService, PageRequestBuilder pageRequestBuilder) {
        this.consentJpaRepository = consentJpaRepository;
        this.piisConsentMapper = piisConsentMapper;
        this.psuDataMapper = psuDataMapper;
        this.piisConsentEntitySpecification = piisConsentEntitySpecification;
        this.piisConsentLazyMigrationService = piisConsentLazyMigrationService;
        this.pageRequestBuilder = pageRequestBuilder;
    }
}

