/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.mapper;

import de.adorsys.psd2.consent.api.ais.CmsConsent;
import de.adorsys.psd2.core.data.ais.AisConsent;
import de.adorsys.psd2.core.mapper.ConsentDataMapper;
import de.adorsys.psd2.xs2a.core.authorisation.Authorisation;
import de.adorsys.psd2.xs2a.core.authorisation.ConsentAuthorization;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.springframework.beans.factory.annotation.Autowired;

@Mapper(componentModel="spring")
public abstract class CmsAisConsentMapper {
    @Autowired
    protected ConsentDataMapper consentDataMapper;

    @Mappings(value={@Mapping(target="consentTppInformation", source="tppInformation"), @Mapping(target="consentData", expression="java(consentDataMapper.mapToAisConsentData(cmsConsent.getConsentData()))"), @Mapping(target="authorisations", expression="java(mapToAccountConsentAuthorisation(cmsConsent.getAuthorisations()))")})
    public abstract AisConsent mapToAisConsent(CmsConsent var1);

    List<ConsentAuthorization> mapToAccountConsentAuthorisation(List<Authorisation> authorisations) {
        if (CollectionUtils.isEmpty(authorisations)) {
            return Collections.emptyList();
        }
        return authorisations.stream().map(this::mapToAccountConsentAuthorisation).collect(Collectors.toList());
    }

    ConsentAuthorization mapToAccountConsentAuthorisation(Authorisation authorisation) {
        return Optional.ofNullable(authorisation).map(auth -> {
            ConsentAuthorization accountConsentAuthorisation = new ConsentAuthorization();
            accountConsentAuthorisation.setId(auth.getAuthorisationId());
            accountConsentAuthorisation.setPsuIdData(auth.getPsuIdData());
            accountConsentAuthorisation.setScaStatus(auth.getScaStatus());
            return accountConsentAuthorisation;
        }).orElse(null);
    }
}

