/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.psu.util;

import de.adorsys.psd2.xs2a.core.pagination.data.PageRequestParameters;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class PageRequestBuilder {
    @Value(value="${cms.defaultPageIndex:0}")
    private int defaultPageIndex;
    @Value(value="${cms.defaultItemsPerPage:20}")
    private int defaultItemsPerPage;

    public Pageable getPageable(Integer pageIndex, Integer itemsPerPage) {
        if (pageIndex == null && itemsPerPage == null) {
            return Pageable.unpaged();
        }
        return PageRequest.of((int)this.getValueOrDefault(pageIndex, this.defaultPageIndex), (int)this.getValueOrDefault(itemsPerPage, this.defaultItemsPerPage));
    }

    public Pageable getPageable(PageRequestParameters pageRequestParameters) {
        if (pageRequestParameters == null) {
            return Pageable.unpaged();
        }
        return this.getPageable(pageRequestParameters.getPageIndex(), pageRequestParameters.getItemsPerPage());
    }

    private int getValueOrDefault(Integer value, int defaultValue) {
        if (value == null || value < 0) {
            return defaultValue;
        }
        return value;
    }
}

