/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.account;

import de.adorsys.psd2.core.data.AccountAccess;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.core.profile.AdditionalInformationAccess;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
public class AccountAccessUpdater {
    @NotNull
    public AccountAccess updateAccountReferencesInAccess(@NotNull AccountAccess existingAccess, @NotNull AccountAccess newAccess) {
        if (this.hasNoAccountReferences(existingAccess)) {
            return new AccountAccess(newAccess.getAccounts(), newAccess.getBalances(), newAccess.getTransactions(), newAccess.getAdditionalInformationAccess());
        }
        List updatedAccounts = existingAccess.getAccounts().stream().map(ref -> this.updateAccountReference((AccountReference)ref, newAccess.getAccounts())).collect(Collectors.toList());
        List updatedBalances = existingAccess.getBalances().stream().map(ref -> this.updateAccountReference((AccountReference)ref, newAccess.getBalances())).collect(Collectors.toList());
        List updatedTransactions = existingAccess.getTransactions().stream().map(ref -> this.updateAccountReference((AccountReference)ref, newAccess.getTransactions())).collect(Collectors.toList());
        AdditionalInformationAccess updatedAdditionalInformation = this.updateAccountReferencesInAdditionalInformation(existingAccess.getAdditionalInformationAccess(), newAccess.getAdditionalInformationAccess());
        return new AccountAccess(updatedAccounts, updatedBalances, updatedTransactions, updatedAdditionalInformation);
    }

    private boolean hasNoAccountReferences(AccountAccess accountAccess) {
        AdditionalInformationAccess additionalInformationAccess = accountAccess.getAdditionalInformationAccess();
        boolean hasNoAdditionalInformationReferences = additionalInformationAccess == null || CollectionUtils.isEmpty((Collection)additionalInformationAccess.getOwnerName());
        return CollectionUtils.isEmpty((Collection)accountAccess.getAccounts()) && CollectionUtils.isEmpty((Collection)accountAccess.getBalances()) && CollectionUtils.isEmpty((Collection)accountAccess.getTransactions()) && hasNoAdditionalInformationReferences;
    }

    private AdditionalInformationAccess updateAccountReferencesInAdditionalInformation(AdditionalInformationAccess existingAccess, AdditionalInformationAccess requestedAccess) {
        if (this.isAdditionalInformationAbsent(existingAccess) || this.isAdditionalInformationAbsent(requestedAccess)) {
            return existingAccess;
        }
        return new AdditionalInformationAccess(this.getAccountReferences(existingAccess.getOwnerName(), requestedAccess.getOwnerName()), this.getAccountReferences(existingAccess.getTrustedBeneficiaries(), requestedAccess.getTrustedBeneficiaries()));
    }

    private List<AccountReference> getAccountReferences(List<AccountReference> existing, List<AccountReference> requested) {
        if (existing != null && requested != null) {
            return existing.stream().map(ref -> this.updateAccountReference((AccountReference)ref, requested)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private boolean isAdditionalInformationAbsent(AdditionalInformationAccess additionalInformationAccess) {
        return additionalInformationAccess == null || this.isAdditionalInformationEmpty(additionalInformationAccess);
    }

    private boolean isAdditionalInformationEmpty(AdditionalInformationAccess additionalInformationAccess) {
        return this.isOwnerNameAbsent(additionalInformationAccess) && this.isTrustedBeneficiariesAbsent(additionalInformationAccess);
    }

    private boolean isOwnerNameAbsent(AdditionalInformationAccess additionalInformationAccess) {
        return additionalInformationAccess.getOwnerName() == null;
    }

    private boolean isTrustedBeneficiariesAbsent(AdditionalInformationAccess additionalInformationAccess) {
        return additionalInformationAccess.getTrustedBeneficiaries() == null;
    }

    private AccountReference updateAccountReference(AccountReference existingReference, List<AccountReference> requestedAspspReferences) {
        return requestedAspspReferences.stream().filter(aspsp -> aspsp.getUsedAccountReferenceSelector().equals((Object)existingReference.getUsedAccountReferenceSelector())).filter(aspsp -> Objects.equals(aspsp.getCurrency(), existingReference.getCurrency())).findFirst().orElse(existingReference);
    }
}

